% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pixset.R
\name{pixset}
\alias{pixset}
\title{Pixel sets (pixsets)}
\usage{
pixset(x)
}
\arguments{
\item{x}{an array of logical values}
}
\description{
Pixel sets represent sets of pixels in images (ROIs, foreground, etc.). From an implementation point of view, they're just a thin layer over arrays of logical values, just like the cimg class is a layer over arrays of numeric values.
Pixsets can be turned back into logical arrays, but they come with a number of generic functions that should make your life easier.
They are created automatically whenever you run a test on an image (for example im > 0 returns a pixset).
}
\examples{
#A test on an image returns a pixset
boats > 250
#Pixsets can be combined using the usual Boolean operators
(boats > 230) & (Xc(boats) < width(boats)/2)
#Subset an image using a pixset
boats[boats > 250]
#Turn a pixset into an image
as.cimg(boats > 250)
#Equivalently:
(boats > 250) + 0
}

