% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{iminfo}
\alias{iminfo}
\title{Return information on image file}
\usage{
iminfo(fname)
}
\arguments{
\item{fname}{path to a file}
}
\value{
a list with fields name, format, width (pix.), height (pix.), size (bytes)
}
\description{
This function calls ImageMagick's "identify" utility on an image file to get some information. You need ImageMagick on your path for this to work.
}
\examples{
\dontrun{
someFiles <- dir("*.png") #Find all PNGs in directory
iminfo(someFiles[1])
#Get info on all files, as a data frame
info <- plyr::ldply(someFiles,function(v) iminfo(v) \%>\% as.data.frame) 
}
}
\author{
Simon Barthelme
}
