% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hough.R
\name{hough_line}
\alias{hough_line}
\title{Hough transform for lines}
\usage{
hough_line(im, ntheta = 100, data.frame = FALSE, shift = TRUE)
}
\arguments{
\item{im}{an image or pixset}

\item{ntheta}{number of bins along theta (default 100)}

\item{data.frame}{return a data.frame? (default FALSE)}

\item{shift}{if TRUE, image is considered to begin at (x=1,y=1).}
}
\value{
either an image or a data.frame
}
\description{
Two algorithms are used, depending on the input: if the input is a pixset then the classical Hough transform is used. If the input is an image, then a faster gradient-based heuristic is used. 
The method returns either an image (the votes), or a data.frame. In both cases the parameterisation used is the Hesse normal form (theta,rho), where a line is represented as the set of values such that cos(theta)*x + sin(theta)*y = rho. Here theta is an angle and rho is a distance.
The image form returns a histogram of scores in (rho,theta) space, where good candidates for lines have high scores. The data.frame form may be more convenient for further processing in R: each line represents a pair (rho,theta) along with its score. 
If the 'shift' argument is true, then the image is assumed to start at x=1,y=1 (more convenient for plotting in R). If false, the image begins at x=0,y=0 and in both cases the origin is at the top left.
}
\examples{
\dontshow{cimg.limit.openmp()}

#Find the lines along the boundary of a square
px <- px.square(30,80,80) \%>\% boundary
plot(px)
#Hough transform
hough_line(px,ntheta=200) \%>\% plot

df <- hough_line(px,ntheta=800,data.frame=TRUE)
#Plot lines with the highest score
plot(px)
with(subset(df,score > quantile(score,.9995)),nfline(theta,rho,col="red"))

plot(boats)
df <- hough_line(boats,ntheta=800,data=TRUE)
}
\author{
Simon Barthelme
}
