## ------------------------------------------------------------------------
library("imbalance")
data(newthyroid1)

head(newthyroid1)

## ---- results=FALSE------------------------------------------------------
numPositive <- length(which(newthyroid1$Class == "positive"))
numNegative <- length(which(newthyroid1$Class == "negative"))
nInstances <-  numNegative - numPositive

## ----example-pdfos, fig.width = 10, fig.height = 10----------------------
newSamples <- pdfos(dataset = newthyroid1, numInstances = 80, 
                    classAttr = "Class")

## ----example-plot, fig.width = 10, fig.height = 10-----------------------
# Bind a balanced dataset
newDataset <- rbind(newthyroid1, newSamples)
# Plot a visual comparison between new and old dataset
plotComparison(newthyroid1, newDataset, 
               attrs = names(newthyroid1)[1:3], classAttr = "Class")

## ----example-neater, fig.width = 10, fig.height = 10---------------------
filteredSamples <- neater(newthyroid1, newSamples, iterations = 500)
filteredNewDataset <- rbind(newthyroid1, filteredSamples)
plotComparison(newthyroid1, filteredNewDataset, 
               attrs = names(newthyroid1)[1:3])

## ---- out.width="60%", fig.align='center', fig.cap='SMOTE generating noise', echo=FALSE, fig.pos="h"----
knitr::include_graphics("smote-flaws.png")

## ---- out.width="50%", fig.align='center', fig.cap='Markov chain generated by Gibbs Sampler', echo=FALSE, fig.pos="h"----
knitr::include_graphics("monte-carlo.png")

## ---- results=FALSE------------------------------------------------------
myWrapper <- structure(list(), class = "C50Wrapper")
trainWrapper.C50Wrapper <- function(wrapper, train, trainClass){
  C50::C5.0(train, trainClass)
}

## ---- results=FALSE------------------------------------------------------
library("FNN")
myWrapper <- structure(list(), class = "KNNWrapper")

predict.KNN <- function(model, test){
  FNN::knn(model$train, test, model$trainClass)
}

trainWrapper.KNNWrapper <- function(wrapper, train, trainClass){
  myKNN <- structure(list(), class = "KNN")
  myKNN$train <- train
  myKNN$trainClass <- trainClass
  myKNN
}

## ---- wracog-example-----------------------------------------------------
data(haberman)

trainFold <- sample(1:nrow(haberman), nrow(haberman)/2, FALSE)
newSamples <- wracog(haberman[trainFold, ], haberman[-trainFold, ],
                     myWrapper, classAttr = "Class")
head(newSamples)

## ---- out.width="75%", fig.align='center', fig.cap='Example of kernel estimation', echo=FALSE, fig.pos="h"----
knitr::include_graphics("kernel-estimation.png")

