% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vis.R
\name{vis.immunr_mds}
\alias{vis.immunr_mds}
\alias{vis.immunr_pca}
\alias{vis.immunr_tsne}
\title{PCA / MDS / tSNE visualisation (mainly overlap / gene usage)}
\usage{
\method{vis}{immunr_mds}(
  .data,
  .by = NA,
  .meta = NA,
  .point = TRUE,
  .text = TRUE,
  .ellipse = TRUE,
  .point.size = 2,
  .text.size = 4,
  ...
)
}
\arguments{
\item{.data}{Output from analysis functions such as \link{geneUsageAnalysis} or
\link{immunr_pca}, \link{immunr_mds} or \link{immunr_tsne}.}

\item{.by}{Pass NA if you want to plot samples without grouping.

You can pass a character vector with one or several column names from ".meta"
to group your data before plotting. In this case you should provide ".meta".

You can pass a character vector that exactly matches the number of samples in
your data, each value should correspond to a sample's property. It will be used
to group data based on the values provided. Note that in this case you should
pass NA to ".meta".}

\item{.meta}{A metadata object. An R dataframe with sample names and their properties,
such as age, serostatus or hla.}

\item{.point}{Logical. If TRUE then plot points corresponding to objects.}

\item{.text}{Logical. If TRUE then plot sample names.}

\item{.ellipse}{Logical. If TRUE then plot ellipses around clusters of grouped samples.}

\item{.point.size}{Numeric. A size of points to plot.}

\item{.text.size}{Numeric. A size of sample names' labels.}

\item{...}{Not used here.}
}
\value{
A ggplot2 object.
}
\description{
PCA / MDS / tSNE visualisation (mainly overlap / gene usage)
}
\details{
Other visualisation methods:

- PCA - \link{vis.immunr_pca}

- MDS - \link{vis.immunr_mds}

- tSNE - \link{vis.immunr_tsne}
}
\examples{
data(immdata)
ov <- repOverlap(immdata$data)
repOverlapAnalysis(ov, "mds") \%>\% vis()

}
\concept{post_analysis}
