% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vis.R
\name{vis.clonal_family_tree}
\alias{vis.clonal_family_tree}
\title{Visualise clonal family tree}
\usage{
\method{vis}{clonal_family_tree}(.data, ...)
}
\arguments{
\item{.data}{Single clonal family tree data from 1 cluster: 1 element from TreeStats column from \code{\link{repClonalFamily}} output.}

\item{...}{Not used here.}
}
\value{
A ggraph object.
}
\description{
Visualise clonal family tree
}
\examples{
data(bcrdata)
bcr_data <- bcrdata$data

clonal_family <- bcr_data \%>\%
  seqCluster(seqDist(bcr_data), .fixed_threshold = 3) \%>\%
  repGermline(.threads = 1) \%>\%
  repAlignLineage(.min_lineage_sequences = 2, .align_threads = 2, .nofail = TRUE) \%>\%
  repClonalFamily(.threads = 1, .nofail = TRUE)

# This condition can be omitted; it prevents the example from crashing
# when ClustalW or PHYLIP are not installed
if (!("step_failure_ignored" \%in\% class(clonal_family))) {
  vis(clonal_family[["full_clones"]][["TreeStats"]][[2]])
}
}
\concept{phylip}
