% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/somatic_hypermutation.R
\name{repSomaticHypermutation}
\alias{repSomaticHypermutation}
\title{Calculates number of mutations against the germline for each clonotype}
\usage{
repSomaticHypermutation(.data, .threads, .nofail)
}
\arguments{
\item{.data}{The data to be processed: an output of repClonalFamily();
variants with one sample and list of samples are both supported.}

\item{.threads}{Number of threads to use.}

\item{.nofail}{Will return NA instead of stopping if Clustal W is not installed.
Used to avoid raising errors in examples on computers where Clustal W is not installed.}
}
\value{
Dataframe or list of dataframes (if input is a list with multiple samples).
The dataframe has all the columns from repClonalFamily() output dataframe, with Sequence
column unnested: the resulting dataframe has one line per clonotype. Clone.ID column
contains original IDs for clonotypes, and can be used as dataframe key.
New columns are added:
* Germline.Alignment.V: contains V gene alignment of current clonotype with the germline
* Germline.Alignment.J: contains J gene alignment of current clonotype with the germline
* Substitutions: contains number of substitutions in the alignment (summary for V and J)
* Insertions: contains number of insertions in the clonotype relative to germline
  (summary for V and J)
* Deletions: contains number of deletions in the clonotype relative to germline
  (summary for V and J)
* Mutations: contains total number of mutations in the alignment (summary for V and J)
}
\description{
This function aligns V and J genes from the germline in each cluster
with corresponding genes in each clonotype, saves the alignments for purpose of visualization,
and calculates number of mutations for each clonotype.
}
\examples{

data(bcrdata)
bcr_data <- bcrdata$data

bcr_data \%>\%
  seqCluster(seqDist(bcr_data), .fixed_threshold = 3) \%>\%
  repGermline(.threads = 1) \%>\%
  repAlignLineage(.min_lineage_sequences = 2, .align_threads = 2, .nofail = TRUE) \%>\%
  repClonalFamily(.threads = 1, .nofail = TRUE) \%>\%
  repSomaticHypermutation(.threads = 1, .nofail = TRUE)
}
\concept{somatic_hypermutation}
