% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/io_immundata_conversion.R
\name{from_immunarch}
\alias{from_immunarch}
\title{Convert an immunarch Object into an ImmunData Dataset}
\usage{
from_immunarch(
  imm,
  output_folder,
  schema = c("CDR3.aa", "V.name"),
  temp_folder = file.path(tempdir(), "temp_folder")
)
}
\arguments{
\item{imm}{A list returned by \code{immunarch::repLoad()}, typically containing:
\itemize{
\item \strong{\code{data}}: a named list of \code{data.frame}s, one per repertoire.
\item \strong{\code{meta}}: (optional) a \code{data.frame} of sample metadata.
}}

\item{output_folder}{Path to the output directory where the resulting ImmunData
Parquet files will be stored. This directory will be created if it does
not already exist.}

\item{schema}{Character vector of column names that together define unique
receptors (for example, \code{c("CDR3.aa", "V.name", "J.name")}).}

\item{temp_folder}{Path to a directory where intermediate TSV files will
be written. Defaults to \code{file.path(tempdir(), "temp_folder")}.}
}
\value{
An \link{ImmunData} object containing all repertoires from the input
immunarch object, with data saved under \code{output_folder}.
}
\description{
The \code{from_immunarch()} function takes an \strong{immunarch} object (as returned by
\code{immunarch::repLoad()}), writes each repertoire to a TSV file with an added
\code{filename} column in a specified folder, and then imports those files into
an \strong{ImmunData} object via \code{read_repertoires()}.
}
\examples{
\dontrun{
imm <- immunarch::repLoad("/path/to/your/files")
idata <- from_immunarch(imm,
  schema = c("CDR3.aa", "V.name"),
  temp_folder = tempdir(),
  output_folder = "/path/to/immundata_out"
)
}

}
\seealso{
\code{\link[=read_repertoires]{read_repertoires()}}, \code{\link[=read_immundata]{read_immundata()}}, \link{ImmunData}
}
\concept{ingestion}
