% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getSquadIterationScores.R
\name{getSquadIterationScores}
\alias{getSquadIterationScores}
\title{Return a dataframe that contains all squads scores for a given iteration ID}
\usage{
getSquadIterationScores(iteration, token)
}
\arguments{
\item{iteration}{'IMPCET' iteration ID}

\item{token}{bearer token}
}
\value{
a dataframe containing the squad scores aggregated per squad for the
given iteration ID
}
\description{
Return a dataframe that contains all squads scores for a given iteration ID
}
\examples{
# Toy example: this will error quickly (no API token)
try(squad_scores <- getSquadIterationScores(
  iteration = 0,
  token = "invalid"
))

# Real usage: requires valid Bearer Token from `getAccessToken()`
\dontrun{
squad_scores <- getSquadIterationScores(
  iteration = 1004,
  token = "yourToken"
)
}
}
