% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/na.random.R
\name{na.random}
\alias{na.random}
\title{Missing Value Imputation by Random Sample}
\usage{
na.random(x, lowerBound = min(x, na.rm = TRUE), upperBound = max(x, na.rm =
  TRUE))
}
\arguments{
\item{x}{Numeric Vector (\code{\link{vector}}) or Time Series (\code{\link{ts}}) object in which missing values shall be replaced}

\item{lowerBound}{Lower bound for the random samples (default is min(data) )}

\item{upperBound}{Upper bound for the random samples (default is max(data) )}
}
\value{
Vector (\code{\link{vector}}) or Time Series (\code{\link{ts}}) object (dependent on given input at parameter x)
}
\description{
Replaces each missing value by drawing a random sample between two given bounds.
}
\details{
Replaces each missing value by drawing a random sample between two given bounds. The 
default bounds are the minimum and the maximum value in the non-NAs from the time series. Function uses
\link{runif} function to get the random values.
}
\examples{
#Prerequisite: Create Time series with missing values
x <- ts(c(2,3,NA,5,6,NA,7,8))

#Example 1: Replace all NAs by random values that are between min and max of the input time series
na.random(x)

#Example 2: Replace all NAs by random values between 1 and 10
na.random(x, lowerBound = 1, upperBound = 10)

#Example 3: Same as example 1, just written with pipe operator
x \%>\% na.random

}
\seealso{
\code{\link[imputeTS]{na.interpolation}},
\code{\link[imputeTS]{na.kalman}}, \code{\link[imputeTS]{na.locf}},
 \code{\link[imputeTS]{na.ma}}, \code{\link[imputeTS]{na.mean}},
 \code{\link[imputeTS]{na.replace}},
 \code{\link[imputeTS]{na.seadec}}, \code{\link[imputeTS]{na.seasplit}}
}
\author{
Steffen Moritz
}
