% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotNA.distributionBar.R
\name{plotNA.distributionBar}
\alias{plotNA.distributionBar}
\title{Visualize Distribution of Missing Values (Barplot)}
\usage{
plotNA.distributionBar(x, breaks = grDevices::nclass.Sturges(x),
  breaksize = NULL, percentage = TRUE, legend = TRUE, axis = TRUE,
  space = 0, col = c("indianred2", "green2"),
  main = "Distribution of NAs", xlab = "Time Lapse", ylab = NULL, ...)
}
\arguments{
\item{x}{Numeric Vector (\code{\link{vector}}) or Time Series (\code{\link{ts}}) object containing NAs}

\item{breaks}{Defines the number of bins to be created. Default number of breaks is calculated by \code{\link[grDevices]{nclass.Sturges}}
using Sturges' formula. If the breaksize parameter is set to a value different to NULL
this parameter is ignored.}

\item{breaksize}{Defines how many observations should be in one bin. The required number of 
overall bins is afterwards calculated automatically. This parameter if used overwrites the breaks parameter.}

\item{percentage}{Whether the NA / non-NA ration should be given as percent or absolute numbers}

\item{legend}{If TRUE a legend is shown at the bottom of the plot. A custom legend can be obtained by
setting this parameter to FALSE and using  \code{\link[graphics]{legend}} function}

\item{axis}{If TRUE a x-axis with labels is added. A custom axis can be obtained by
setting this parameter to FALSE and using  \code{\link[graphics]{axis}} function}

\item{space}{The amount of space (as a fraction of the average bar width) left before each bar.}

\item{col}{A vector of colors for the bars or bar components.}

\item{main}{Main title for the plot}

\item{xlab}{Label for x axis of the plot}

\item{ylab}{Label for y axis of plot}

\item{...}{Additional graphical parameters that can be passed through to barplot}
}
\description{
Visualization of missing values in barplot form. Especially useful for
time series with a lot of observations.
}
\details{
This function visualizes the distribution of missing values within a time series.
In comparison to the \code{\link[imputeTS]{plotNA.distribution}} function this is not done by plotting
each observation of the time series separately Instead observations for time intervals are represented as bars.
For these intervals information about the amount of missing values are shown. This has the advantage, that also
for large time series a plot which is easy to overview can be created.
}
\examples{
#Example 1: Visualize the missing values in tsNH4 time series
plotNA.distributionBar(tsNH4)

#Example 2: Visualize the missing values in tsHeating time series
plotNA.distributionBar(tsHeating, breaks = 20)

#Example 3: Same as example 1, just written with pipe operator
tsNH4 \%>\% plotNA.distributionBar

}
\seealso{
\code{\link[imputeTS]{plotNA.distribution}},
 \code{\link[imputeTS]{plotNA.gapsize}}, \code{\link[imputeTS]{plotNA.imputations}}
}
\author{
Steffen Moritz
}
