% Generated by roxygen2: do not edit by hand
% Please edit documentation in
%   R/flextable-convertSummaryStatisticsTableToFlextable.R
\name{convertSummaryStatisticsTableToFlextable}
\alias{convertSummaryStatisticsTableToFlextable}
\title{Convert summary statistics table to flextable}
\usage{
convertSummaryStatisticsTableToFlextable(
  summaryTable,
  colHeaderMerge = TRUE,
  landscape = (style == "presentation"),
  margin = 1,
  rowPadBase = 14.4,
  title = NULL,
  footer = NULL,
  style = "report",
  colorTable = getColorPaletteTable(style = style),
  fontname = switch(style, report = "Times", presentation = "Tahoma"),
  fontsize = switch(style, report = 8, presentation = 10),
  file = NULL,
  pageDim = NULL,
  columnsWidth = NULL
)
}
\arguments{
\item{summaryTable}{A \code{\link{summaryTable}} object.}

\item{colHeaderMerge}{(flextable output) Logical, if TRUE (FALSE by default) 
the column header is merged.}

\item{landscape}{(flextable output) Logical, if TRUE the file is in landscape format.\cr
By default: FALSE if \code{style} is 'report' and TRUE if \code{style} is 'presentation'.}

\item{margin}{(flextable output) Margin in the document in inches
(1 by default).
This is used to specify the width of the table, from:
[\code{pageDim[1]} - 2 * margin].}

\item{rowPadBase}{(flextable output) Base padding for row (in points), 
14.4 by default (corresponds to 0.2 inches)}

\item{title}{Character vector with title(s) for the table.
Set to NULL (by default) if no title should be included.
If multiple are specified, specified for each element of \code{byVar} (in order of the levels).}

\item{footer}{(flextable output) Character vector with footer(s) for the table.
Set to NULL (by default) if no footer should be included.}

\item{style}{(flextable output) String with table style,
 either 'report' or 'presentation'.
This parameter affects the fontsize, font family, color of the text and background, 
and table dimensions of the table.}

\item{colorTable}{(flextable output) Named character vector with color for the table background/body/text/line,
e.g. created with the \code{\link{getColorPaletteTable}} function.}

\item{fontname}{(flextable output) String with font name, by default:
'Times' if \code{style} is 'report' and 'Tahoma' if \code{style} is 'presentation'.}

\item{fontsize}{(flextable output) Integer with font size, by default:
8 if \code{style} is 'report' and 10 if \code{style} is 'presentation'.}

\item{file}{String with path of the file where the table should be exported.
The file should have the extension: '.html'.
If NULL, the summary table is not exported but only returned as output.
If \code{byVar} is specified, each table is exported to a separated
file with the suffix: 'file_[i].html' with i the index of the file.}

\item{pageDim}{Numeric vector of length 2 with page width and height.\cr
Depending on \code{outputType}:
\itemize{
\item{'flextable': }{in inches}
\item{'DT': }{in number of rows in the table.\cr
Currently only the height is used (e.g. \code{c(NA, 4)})
}}}

\item{columnsWidth}{(expert mode) Column widths of the table. This is only used 
for flextable and DT tables.\cr
For flextable, note that the widths should be set to fit into the document page
(see \code{\link{getDimPage}}).}
}
\value{
\code{\link[flextable]{flextable}} object with summary table
If \code{summaryTable} is a list of summary tables,
returns a list of \code{\link[flextable]{flextable}}.
}
\description{
Convert summary statistics table to flextable
}
\author{
Laure Cougnaud
}
