% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decimals.R
\name{getMaxNDecimals}
\alias{getMaxNDecimals}
\title{Get maximum number of decimals in a variable,
based on pre-defined rule and/or data.}
\usage{
getMaxNDecimals(x, ...)
}
\arguments{
\item{x}{Numeric vector.}

\item{...}{Any parameters for the \code{\link{getNDecimals}} function.}
}
\value{
Integer with maximum number of decimals in a character vector.
}
\description{
The function \code{\link{getNDecimals}}) extracts the number
of decimals in a specific variable.
}
\examples{
x <- c(0.99, 5.679, 50.45, 1450)
# extract max number of decimals based on data:
getMaxNDecimals(x, useRule = FALSE, useData = TRUE)
# extract max number of decimals based on pre-defined rule:
getMaxNDecimals(x, useRule = TRUE, useData = FALSE)
# extract max number of decimals based on both rules
# minimum of both is used (by default)
getMaxNDecimals(x, useRule = TRUE, useData = TRUE)
}
\seealso{
Other decimals: 
\code{\link{formatPercentage}()},
\code{\link{getMaxNDecimalsData}()},
\code{\link{getNDecimals}()},
\code{\link{getNDecimalsData}()}
}
\author{
Laure Cougnaud
}
\concept{decimals}
