% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/HHC.R
\name{HHC}
\alias{HHC}
\title{Calculates heterzygosity-heterozygosity correlations with
standardized multilocus heterozygosities (sMLH)}
\usage{
HHC(genotypes, niter = 100, CI = 0.95)
}
\arguments{
\item{genotypes}{data.frame with individuals in rows and loci in columns,
containing genotypes coded as 0 (homozygote), 1 (heterozygote) and NA (missing)}

\item{niter}{number of iterations, i.e. splittings of the dataset}

\item{CI}{calculates a CI around the mean het-het correlation}
}
\value{
\item{call}{function call.}
\item{HHC_vals}{vector of HHC`s obtained by randomly splitting the dataset}
\item{summary_exp_r2}{r2 mean and sd for each number of subsetted loci}
\item{nobs}{number of observations}
\item{nloc}{number of markers}
}
\description{
Loci are randomly devided into two equal groups and the correlation coefficient
between the resulting sMLH values is calculated.
}
\examples{
data(mouse_msats)
genotypes <- convert_raw(mouse_msats)
(out <- HHC(genotypes, niter = 100, CI = 0.95))
}
\author{
Martin A. Stoffel (martin.adam.stoffel@gmail.com)
}
\references{
Balloux, F., Amos, W., & Coulson, T. (2004). Does heterozygosity estimate inbreeding
in real populations?. Molecular Ecology, 13(10), 3021-3031.
}

