% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.incidence}
\alias{plot.incidence}
\title{Plot function for incidence objects}
\usage{
\method{plot}{incidence}(x, ..., fit = NULL, stack = is.null(fit),
  color = "black", border = NA, col_pal = pal1, alpha = 0.7,
  xlab = "", ylab = NULL, labels_iso_week = TRUE)
}
\arguments{
\item{x}{An incidence object, generated by the function
\code{\link{incidence}}.}

\item{...}{Further arguments passed to other methods (currently not used).}

\item{fit}{An 'incidence_fit' objet as returned by \code{\link{fit}}.}

\item{stack}{A logical indicating if bars of multiple groups should be
stacked, or displayed side-by-side.}

\item{color}{The color to be used for the filling of the bars; NA for
invisiable bars; defaults to "black".}

\item{border}{The color to be used for the borders of the bars; NA for
invisiable borders; defaults to NA.}

\item{col_pal}{The color palette to be used for the groups; defaults to
\code{pal1}. See \code{\link{pal1}} for other palettes implemented in
incidence.}

\item{alpha}{The alpha level for color transparency, with 1 being fully
opaque and 0 fully transparent; defaults to 0.7.}

\item{xlab}{The label to be used for the x-axis; empty by default.}

\item{ylab}{The label to be used for the y-axis; by default, a label will be
generated automatically according to the time interval used in incidence
computation.}

\item{labels_iso_week}{a logical value indicating whether labels x axis tick
marks are in ISO 8601 week format yyyy-Www when plotting ISO week-based weekly
incidence; defaults to be TRUE.}
}
\description{
This function is used to visualise the output of the \code{\link{incidence}}
function, using the package \code{ggplot2}.
}
\examples{

if(require(outbreaks)) {
  onset <- ebola.sim$linelist$date.of.onset

  ## daily incidence
  inc <- incidence(onset)
  inc
  plot(inc)

  ## weekly incidence
  inc.week <- incidence(onset, interval = 7)
  inc.week
  plot(inc.week) # default to label x axis tick marks with isoweeks
  plot(inc.week, labels_iso_week = FALSE) # label x axis tick marks with dates
  plot(inc.week, border = "white") # with visible border

  ## use group information
  sex <- ebola.sim$linelist$gender
  inc.week.gender <- incidence(onset, interval = 7, groups = sex)
  plot(inc.week.gender)
  plot(inc.week.gender, labels_iso_week = FALSE)

  ## adding fit
  fit <- fit_optim_split(inc.week.gender)$fit
  plot(inc.week.gender, fit = fit)
  plot(inc.week.gender, fit = fit, labels_iso_week = FALSE)
}

}
\author{
Thibaut Jombart \email{thibautjombart@gmail.com}
}
\seealso{
The \code{\link{incidence}} function to generate the 'incidence'
objects.
}

