% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/new_incidence.R
\name{new_incidence}
\alias{new_incidence}
\alias{validate_incidence}
\title{Incidence constructor and validator}
\usage{
new_incidence(
  x,
  date,
  groups = NULL,
  counts,
  measurements = NULL,
  validate = TRUE
)

validate_incidence(x)
}
\arguments{
\item{x}{An incidence-like object}

\item{date}{The time index of `x.}

\item{groups}{An optional vector giving the names of the groups in \code{x}.}

\item{counts}{The count variables of \code{x}}

\item{measurements}{An optional vector giving the names of measurement
variables in \code{x}.}

\item{validate}{A logical value indicating whether to validate the input.
If FALSE, only minimal checks are made which can give a performance
advantage if so desired.}
}
\value{
An incidence object (invisibly for \code{validate_incidence()})
}
\description{
Creates or validates an incidence object. Mainly of use to those developing
packages to work with incidence objects.
}
\details{
\code{new_incidence()} creates a new incidence object which is a subclass
of a tibble (i.e. class \code{incidence}, \code{tbl_df}, \code{tbl} and \code{data.frame}).

\code{validate_incidence()} checks the object for internal consistency. For an
object to be considered an incidence object it must:
* \code{inherit} the incidence and data.frame class;
* have a single column representing the date_index with the name of this
variable being stored in the \code{date} attribute;
* have one or more columns representing the counts with the name of
these variables being stored in the \code{counts} attribute;
* have zero or more columns representing groups with, if and only if
present, the names of these being stored in the \code{groups} attribute;
* have zero or more columns representing measurement with, if and only
if present, the names of these being stored in the \code{measurements}
attribute;
* not have duplicated rows with regards to the date and group variables.
}
