% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/complete_dates.R
\name{complete_dates}
\alias{complete_dates}
\title{Complete dates for all group combinations}
\usage{
complete_dates(x, expand = TRUE, fill = 0L, by = 1L)
}
\arguments{
\item{x}{\verb{<incidence2>} object.}

\item{expand}{\verb{[logical]}

Should a range of dates from the minimum to maximum value of the date index
also be created.}

\item{fill}{\verb{[numeric]}

The value to replace missing counts by. Defaults to \code{0L}.}

\item{by}{Passed as the \code{by} argument to seq.

If \code{expand} is TRUE (default) then complete_dates will attempt to use
\code{function(x) seq(min(x), max(x), by = by)} to generate a complete sequence of
dates.

Defaults to \code{1L}.}
}
\value{
An \verb{<incidence2>} object.
}
\description{
This function ensures that an incidence object has the same range of dates
for each grouping. By default missing counts will be filled with \code{0L}.
}
\examples{
x <- data.frame(
    dates = Sys.Date() + c(1,3,4),
    groups = c("grp1","grp2", "grp1"),
    counts = 1:3
)

i <- incidence(x, date_index = "dates", groups = "groups", counts = "counts")
complete_dates(i)

}
