% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/delay_test.R
\name{power_diff}
\alias{power_diff}
\title{Power simulation function for a two-group comparison of the delay parameter.}
\usage{
power_diff(
  distribution = c("exponential", "weibull"),
  param = "delay",
  test = c("bootstrap", "pearson", "moran", "lr", "lr_pp"),
  eff = stop("Provide parameters for both group that reflect the effect!"),
  n = NULL,
  r = 1,
  sig.level = 0.05,
  power = NULL,
  nPowerSim = 1600,
  R = 201,
  nRange = c(5, 50)
)
}
\arguments{
\item{distribution}{character. Which assumed distribution is used for the power calculation.}

\item{param}{character. Parameter name(s) for which to simulate the power.}

\item{test}{character. Which test to use for this power estimation?}

\item{eff}{list. The two list elements contain the model parameters (as understood by the delay-distribution functions provided by this package) for the two groups.}

\item{n}{integer. Number of observations per group for the power simulation or \code{NULL} when n is to be estimated for a given power.}

\item{r}{numeric. Ratio of both groups sizes, ny / nx. Default value is 1, i.e., balanced group sizes. Must be positive.}

\item{sig.level}{numeric. Significance level. Default is 0.05.}

\item{power}{numeric. \code{NULL} when power is to be estimated for a given sample size or a desired power is specified (and \code{n} is estimated).}

\item{nPowerSim}{integer. Number of simulation rounds. Default value 1600 yields a standard error of 0.01 for power if the true power is 80\%.}

\item{R}{integer. Number of bootstrap samples for test of difference in parameter within each power simulation. It affects the resolution of the P-value for each simulation round. A value of around \code{R=200} gives a resolution of 0.5\% which might be enough for power analysis.}

\item{nRange}{integer. Admissible range for sample size when power is pre-specified and sample size is requested.}
}
\value{
List of results of power simulation. Or \code{NULL} in case of errors.
}
\description{
There are two ways of operation:
\enumerate{
\item \code{power=NULL} Given sample size \code{n} it simulates the power.
\item \code{n=NULL} Given a power an iterative search is started to find a suitable \code{n} within a specified range.
}
}
\details{
In any case, the distribution, the parameters that are tested for, the type of test and the effect size (\verb{eff=}) need to be specified.
The more power simulation rounds (parameter \verb{nPowerSim=}) the more densely the space of data according to the specified model is sampled.

Note that this second modus (when \code{n} is estimated) is computationally quite heavy.
The iterative search for \code{n} uses some heuristics and the estimated sample size might actually give a different power-level.
It is important to check the stated power in the output. The search algorithm comes to results closer to the power aimed at
when the admissible range for sample size (\verb{nRange=}) is chosen sensibly.
In case the estimated sample size and the achieved power is too high it might pay off to rerun the function with an adapted admissible range.
}
