% Generated by roxygen2 (4.0.2): do not edit by hand
\name{image_features}
\alias{image_features}
\title{Detects image features}
\usage{
image_features(img, local.api = FALSE)
}
\arguments{
\item{img}{image data}

\item{local.api}{logical, whether use local or remote API}
}
\value{
List with image features
}
\description{
Given an input image, returns a 2048 dimensional sparse feature vector explaining that image.
Useful as a form of feature engineering for image oriented tasks.
}
\details{
* Input can be either grayscale or rgb color and should either be a numpy array or nested list format.

* Input data should be either uint8 0-255 range values or floating point between 0 and 1.

* Large images (i.e. 1024x768+) are much bigger than needed, resizing will be done internally to 64x64 if needed.

* For ideal performance, images should be square aspect ratio but non-square aspect ratios are supported as well.
}
\examples{
img <- matrix(runif(64*64, 0, 1), nrow = 64)
features <- image_features(img)

length(features)
min(unlist(features))
max(unlist(features))
sum(unlist(features))
}
\seealso{
\code{\link{face_emotion}}, \code{\link{face_features}}
}
\keyword{API}
\keyword{features}
\keyword{image}
\keyword{indico.io}
\keyword{learning}
\keyword{machine}
\keyword{recognition}

