% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_us_states_covid_stats.R
\name{get_us_states_covid_stats}
\alias{get_us_states_covid_stats}
\title{Get COVID-19 Statistics for U.S. States and Territories}
\usage{
get_us_states_covid_stats()
}
\value{
A data frame with the following columns:
\itemize{
  \item \code{state}: Name of the U.S. state.
  \item \code{cases}: Total confirmed cases in the state.
  \item \code{todayCases}: New confirmed cases today.
  \item \code{deaths}: Total deaths in the state.
  \item \code{todayDeaths}: New deaths today.
  \item \code{active}: Current active cases.
  \item \code{population}: Estimated state population.
}
}
\description{
Retrieves real-time COVID-19 totals from the 'disease.sh' API for all 50 U.S. states,
as well as U.S. territories (e.g., Puerto Rico, Guam), special jurisdictions
(e.g., Veteran Affairs, U.S. Military), and others (e.g., cruise ships, repatriated individuals).
}
\details{
This function sends a GET request to the 'disease.sh' API endpoint for US state-level COVID-19
statistics and parses the response into a structured data frame.
The timestamp is converted to a readable date-time format (in UTC).
}
\note{
An internet connection is required to use this function.
}
\examples{
\donttest{
us_states_stats <- get_us_states_covid_stats()
head(us_states_stats)
}

}
\references{
API Docs: https://disease.sh/docs/#/COVID-19:%20Worldometers/get_v3_covid_19_states
}
