% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/network.visualization.R
\name{plot_dynamic_networks}
\alias{plot_dynamic_networks}
\title{plot_dynamic_networks}
\usage{
plot_dynamic_networks(
  network_table,
  celltypes_order,
  ntop = 10,
  width = 6,
  height = 6,
  seed = 2024,
  theme_type = "theme_void",
  plot_type = "ggplot",
  layout = "fruchtermanreingold",
  nrow = 2,
  title = NULL,
  figure_save = FALSE,
  figure_name = NULL
)
}
\arguments{
\item{network_table}{network_table}

\item{celltypes_order}{celltypes_order}

\item{ntop}{ntop}

\item{width}{width}

\item{height}{height}

\item{seed}{seed}

\item{theme_type}{theme_type}

\item{plot_type}{plot_type}

\item{layout}{layout}

\item{nrow}{nrow}

\item{title}{The title of figure.}

\item{figure_save}{figure_save}

\item{figure_name}{figure_name}
}
\value{
ggplot object
}
\description{
plot_dynamic_networks
}
\examples{
data("example_matrix")
network <- inferCSN(example_matrix)[1:100, ]
network$celltype <- c(
  rep("cluster5", 20),
  rep("cluster1", 20),
  rep("cluster3", 20),
  rep("cluster2", 20),
  rep("cluster6", 20)
)

celltypes_order <- c(
  "cluster5", "cluster3",
  "cluster2", "cluster1",
  "cluster6"
)

plot_dynamic_networks(
  network,
  celltypes_order = celltypes_order
)

plot_dynamic_networks(
  network,
  celltypes_order = celltypes_order[1:3]
)

\dontrun{
# If setting `plot_type = "animate"` to plot and save `gif` figure,
# please install `gifski` package first.
plot_dynamic_networks(
  network,
  celltypes_order = celltypes_order,
  plot_type = "animate"
)
}

plot_dynamic_networks(
  network,
  celltypes_order = celltypes_order,
  plot_type = "ggplotly"
)
}
