% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/injsummary.R
\name{injsummary_unit}
\alias{injsummary_unit}
\title{Transform injsummary() output according to the unit of exposure}
\usage{
injsummary_unit(unit, injds, quiet)
}
\arguments{
\item{unit}{Character that indicates the unit of exposure of the sports
injury data.}

\item{injds}{\code{injds} data frame to be transformed.}

\item{quiet}{Logical, whether or not to silence the warning messages
(defaults to \code{FALSE}).}
}
\value{
A list of two elements:
(i) same injds data frame with 'injincidence'
and 'injburden' values transformed according to \code{unit}, named
\code{injds} and
(ii) a character vector that expresses the unit used for the rates, i.e.
for the player's time at risk, named \code{unit_timerisk}.
}
\description{
Transform injsummary() output according to the unit of exposure
}
\keyword{internal}
