% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplot.R
\name{gg.SpatialLines}
\alias{gg.SpatialLines}
\title{Geom for SpatialLines objects}
\usage{
\method{gg}{SpatialLines}(data, mapping = NULL, crs = NULL, ...)
}
\arguments{
\item{data}{A SpatialLines object.}

\item{mapping}{Aesthetic mappings created by \link{aes} or \link{aes_} used to update the default
mapping. The default mapping is \code{aes_string(x = coordnames(data)[1], 
y = coordnames(data)[2], 
xend = paste0("end.", coordnames(data)[1]), 
yend = paste0("end.", coordnames(data)[2]))}.}

\item{crs}{A \link{CRS} object defining the coordinate system to project the data to before plotting.}

\item{...}{Arguments passed on to \link{geom_segment}.}
}
\value{
A \link{geom_segment} return value.
}
\description{
Extracts start and end points of the lines and calls \link{geom_segment} to plot  lines between them.
}
\examples{
\donttest{
# Load Gorilla data

data("gorillas", package = "inlabru")

# Plot Gorilla elevation covariate provided as SpatialPixelsDataFrame. 
# The same syntax applies to SpatialGridDataFrame objects.

ggplot() + gg(gorillas$gcov$elevation)

# Add Gorilla survey boundary and nest sightings

ggplot() + 
  gg(gorillas$gcov$elevation) + 
  gg(gorillas$boundary) +
  gg(gorillas$nests)

# Load pantropical dolphin data

data("mexdolphin")

# Plot the pantropiical survey boundary, ship transects and dolphin sightings

ggplot() + 
  gg(mexdolphin$ppoly) + # survey boundary as SpatialPolygon
  gg(mexdolphin$samplers) + # ship transects as SpatialLines
  gg(mexdolphin$points)  # dolphin sightings as SpatialPoints

# Change color

ggplot() + 
  gg(mexdolphin$ppoly, color = "green") + # survey boundary as SpatialPolygon
  gg(mexdolphin$samplers, color = "red") + # ship transects as SpatialLines
  gg(mexdolphin$points, color = "blue")  # dolphin sightings as SpatialPoints


# Visualize data annotations: line width by segment number

names(mexdolphin$samplers) # 'seg' holds the segment number
ggplot() + gg(mexdolphin$samplers, aes(color = seg))

# Visualize data annotations: point size by dolphin group size

names(mexdolphin$points) # 'size' holds the group size
ggplot() + gg(mexdolphin$points, aes(size = size))
}
}
\seealso{
Other geomes for spatial data: \code{\link{gg.SpatialGridDataFrame}},
  \code{\link{gg.SpatialPixelsDataFrame}},
  \code{\link{gg.SpatialPixels}},
  \code{\link{gg.SpatialPoints}},
  \code{\link{gg.SpatialPolygons}}, \code{\link{gg}},
  \code{\link{gm}}
}
\concept{geomes for spatial data}
