% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inlabru-package.R
\docType{package}
\name{inlabru-package}
\alias{inlabru-package}
\alias{inlabru}
\title{inlabru}
\description{
Convenient model fitting using (iterated) INLA.
}
\details{
\code{inlabru} facilitates Bayesian spatial modelling using integrated nested
Laplace approximations. It is heavily based on R-inla
(\url{https://www.r-inla.org}) but adds additional modelling abilities and
simplified syntax for (in particular) spatial models.
Tutorials and more information can be found at
\url{https://inlabru-org.github.io/inlabru/} and \url{http://www.inlabru.org/}.
The iterative method used for non-linear predictors is documented in the
\code{method} vignette.

The main function for inference using inlabru is \code{\link[=bru]{bru()}}.
The general model specification details is documented in \code{\link[=bru_component]{bru_component()}}
and \code{\link[=bru_obs]{bru_obs()}}.
Posterior quantities beyond the basic summaries can be calculated with
a \code{predict()} method, documented in \code{\link[=predict.bru]{predict.bru()}}.
For point process inference \code{\link[=lgcp]{lgcp()}} can be used as a shortcut to
\code{bru(..., bru_obs(model="cp", ...))}.

The package comes with multiple real world data sets, namely \link{gorillas},
\link{gorillas_sf}, \link{mexdolphin_sf}. Plotting these data
sets is straight forward using inlabru's extensions
to \code{ggplot2}, e.g. the \code{\link[=gg]{gg()}} function. For educational purposes some
simulated data sets are available as well, e.g. \link{Poisson1_1D},
\link{Poisson2_1D}, \link{Poisson2_1D} and \link{toygroups}.
}
\seealso{
Useful links:
\itemize{
  \item \url{http://www.inlabru.org}
  \item \url{https://inlabru-org.github.io/inlabru/}
  \item \url{https://github.com/inlabru-org/inlabru}
  \item Report bugs at \url{https://github.com/inlabru-org/inlabru/issues}
}

}
\author{
Fabian E. Bachl \email{bachlfab@gmail.com}
and Finn Lindgren \email{finn.lindgren@gmail.com}
}
