% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inldata.R
\docType{package}
\name{inldata-package}
\alias{inldata}
\alias{inldata-package}
\title{inldata: Collection of Datasets for the USGS-INL Monitoring Networks}
\description{
A collection of analysis-ready datasets for the U.S. Geological Survey - Idaho National Laboratory (USGS-INL) groundwater and surface-water monitoring networks, administered by the USGS-INL Project Office in cooperation with the U.S. Department of Energy. The data collected from wells and surface-water stations at the Idaho National Laboratory and surrounding areas have been used to describe the effects of waste disposal on water contained in the eastern Snake River Plain aquifer, located in the southeastern part of Idaho, and the availability of water for long-term consumptive and industrial use. The package includes long-term monitoring records dating back to measurements from 1922. Geospatial data describing the areas from which samples were collected or observations were made are also included in the package. Bundling this data into a single package significantly reduces the magnitude of data processing for researchers and provides a way to distribute the data along with its documentation in a standard format. Geospatial datasets are made available in a common projection and datum, and geohydrologic data have been structured to facilitate analysis.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://code.usgs.gov/inl/inldata}
  \item \url{https://rconnect.usgs.gov/INLPO/inldata-main/}
  \item Report bugs at \url{https://code.usgs.gov/inl/inldata/-/issues}
}

}
\author{
\strong{Maintainer}: Jason C. Fisher \email{jfisher@usgs.gov} (\href{https://orcid.org/0000-0001-9032-8912}{ORCID})

Authors:
\itemize{
  \item Allison R. Trcka \email{atrcka@usgs.gov} (\href{https://orcid.org/0000-0001-8498-4737}{ORCID})
  \item Kerri C. Treinen \email{ktreinen@usgs.gov} (\href{https://orcid.org/0000-0003-0645-6810}{ORCID})
}

}
\keyword{internal}
