% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_shade.R
\name{make_shade}
\alias{make_shade}
\title{Compute Hill Shade}
\usage{
make_shade(
  x,
  scale = 2,
  neighbors = 8,
  angle = 40,
  direction = 270,
  normalize = TRUE
)
}
\arguments{
\item{x}{'SpatRaster' object.
Spatial raster of land-surface elevations, such as the \code{\link{dem}} dataset.}

\item{scale}{'numeric' number.
Scaling factor used to convert the elevation values.
The default value is 2.}

\item{neighbors}{'numeric' count.
Number of neighboring cells to use to compute slope or aspect with.
Either 8 (queen case) or 4 (rook case).}

\item{angle}{'numeric' number.
The sun's angle of elevation above the horizon, ranges from 0 to 90 degrees.
A value of 0 degrees indicates that the sun is on the horizon.
A value of 90 degrees indicates that the sun is directly overhead.
Default is a 40 degree angle.}

\item{direction}{'numeric' number.
Direction (azimuth) angle of the light source (sun), in degrees.
An direction of 0 degrees indicates north, east is 90 degrees, south is 180 degrees,
and west is 270 degrees (default).}

\item{normalize}{'logical' flag.
Whether to set values below zero to zero and results normalized between 0 and 1.}
}
\value{
Spatial raster of hill shade values.
}
\description{
Compute hill shade from a digital elevation model.
A hill shade layer is often used as a backdrop on top of which another, semi-transparent, layer is drawn.
}
\examples{
elevation <- terra::unwrap(dem)
hillshade <- make_shade(elevation)
print(hillshade)

col <- inlcolor::get_colors(n = 256, scheme = "grayC")
mar <- c(2, 2, 1, 4)
terra::plot(hillshade, col = col, mar = mar)

terra::plot(hillshade, col = col, mar = mar, legend = FALSE)
terra::plot(elevation,
  col = inlcolor::get_colors(
    n = 256,
    scheme = "dem2",
    alpha = 0.7,
    bias = 0.9
  ),
  add = TRUE
)
}
\author{
J.C. Fisher, U.S. Geological Survey, Idaho Water Science Center
}
