% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ToScientific.R
\name{ToScientific}
\alias{ToScientific}
\title{Format for Scientific Notation}
\usage{
ToScientific(x, digits = NULL, type = c("latex", "plotmath"),
  na = as.character(NA), delimiter = "$", scipen = NULL, ...)
}
\arguments{
\item{x}{'numeric'.
Vector of numbers}

\item{digits}{'integer'.
Number of digits after the decimal point for the coefficent part of a number in scientific notation.}

\item{type}{'character'.
Specify \code{"latex"} to return numbers in the LaTeX markup language (default),
or \code{"plotmath"} to return as \code{\link[grDevices]{plotmath}} expressions.}

\item{na}{'character'.
String to be used for missing values (\code{NA}).
By default, no string substitution is made for missing values.}

\item{delimiter}{'character'.
Delimiter for LaTeX mathematical mode, inline (\code{$...$}) by default.}

\item{scipen}{'integer'.
A penalty to be applied when deciding to format numeric values in scientific or fixed notation.
Positive values bias towards fixed and negative towards scientific notation:
fixed notation will be preferred unless it is more than \code{scipen} digits wider.
By default, all numbers, with the exception of zero, are formatted in scientific notation.}

\item{...}{Arguments passed to the \code{\link{formatC}} function.
Only applies to fixed formatted values that are not equal to zero.}
}
\value{
For \code{type = "latex"}, returns a 'character' vector of the same length as argument \code{x}.
  And for \code{type = "plotmath"}, returns an 'expression' vector of the same length as \code{x}.
}
\description{
This function formats numbers in scientific notation \eqn{m \times 10^{n}}{m x 10^n}.
}
\note{
As a workaround for \href{https://www.section508.gov}{Section 508} compliance,
  the letter "x" is used as the times symbol in plotmath expressions---rather
  than the noncompliant (but better looking) times symbol produced by the \code{"\%*\%"} syntax.
}
\examples{
x <- c(-1e+09, 0, NA, pi * 10^(-5:5))
ToScientific(x, digits = 5L, na = "---")
ToScientific(x, digits = 2L, scipen = 0L)

x <- exp(log(10) * 1:6)
i <- seq_along(x)
plot(i, i, type = "n", xaxt = "n", yaxt = "n", ann = FALSE)
lab <- ToScientific(x, 0L, type = "plotmath", scipen = 0L, big.mark = ",")
axis(1, i, labels = lab)
axis(2, i, labels = lab)

}
\author{
J.C. Fisher, U.S. Geological Survey, Idaho Water Science Center
}
\keyword{utilities}
