% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ReadCodeChunks.R
\name{ReadCodeChunks}
\alias{ReadCodeChunks}
\title{Read Knitr Code Chunks}
\usage{
ReadCodeChunks(path)
}
\arguments{
\item{path}{'character' string.
Path name of the \bold{knitr} source document (\file{.Rnw} or \file{.Rmd}),
or R code that has been extracted from a \bold{knitr} source document (\file{.R}).}
}
\value{
A 'list' of length equal to the number of code chunks in \code{path}.
  Each list component is named after its corresponding chunk name (\code{chunk-name}).
  The returned object includes the value of the \code{path} argument as an attribute.
}
\description{
Read \bold{knitr} code chunks into the current session.
}
\details{
If the source document is \file{.Rnw} or \file{.Rmd} the \code{purl} function is used to extract the R code.
  The R code is read into the current session using a chunk separator of the from \code{## ---- chunk-name}
  (at least four dashes before the chunk name) in the script.
  Unnamed chunks (that is, \code{chunk-name} is missing) will be assigned
  names like \code{unnamed-chunk-i} where \code{i} is the chunk number.
}
\examples{
file <- system.file("misc/knitr-markdown.Rmd", package = "inlmisc")
chunks <- ReadCodeChunks(file)
print(chunks)
attr(chunks, "path")

txt <- chunks[c("unnamed-chunk-3", "named-chunk-4")]
eval(parse(text = unlist(txt)))

}
\author{
J.C. Fisher, U.S. Geological Survey, Idaho Water Science Center
}
\keyword{utilities}
