% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mine_text.R
\name{mine_text}
\alias{mine_text}
\title{Mine Text Components in the INLPO Publications}
\usage{
mine_text(
  pubs,
  components = c("title", "abstract"),
  ngmin = 1L,
  ngmax = ngmin,
  lowfreq = 1L
)
}
\arguments{
\item{pubs}{'pub' class.
Bibliographic information, see \code{\link{pubs}} dataset for details.}

\item{components}{character vector.
One or more text components to analyze.
Choices include the "title", "abstract", "annotation", and "bibentry" of the document.}

\item{ngmin, ngmax}{integer number.
Splits strings into \emph{n-grams} with given minimal and maximal numbers of grams.
An n-gram is an ordered sequence of n words taken from the body of a text.
Requires the \pkg{RWeka} package is available and that the
environment variable JAVA_HOME points to where the Java software is located.
Recommended for single text compoents only.}

\item{lowfreq}{integer number.
Lower frequency bound.
Words that occur less than this bound are excluded from the returned frequency table.}
}
\value{
A word frequency table giving the number of times each word occurs in a publication's text component(s).
A table column represents a single publication that is identified using its bibentry-key.
And each row provides frequency counts for a particular word (also known as a 'term').
}
\description{
Performs a word frequency text analysis of Idaho National Laboratory Project Office
(\href{https://www.usgs.gov/centers/idaho-water-science-center/science/idaho-national-laboratory-project-office}{INLPO})
publications.
}
\details{
HTML entities are decoded when the \pkg{textutils} package is available.
}
\examples{
m <- head(pubs, 3) |> mine_text()
head(m)

\dontrun{
  d <- data.frame(word = rownames(m), freq = rowSums(m))
  file <- make_wordcloud(d, display = interactive())
  unlink(file)
}
}
\seealso{
\code{\link{make_wordcloud}} function to create a word cloud.
}
\author{
J.C. Fisher, U.S. Geological Survey, Idaho Water Science Center
}
