% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is_bayesian_model.R
\name{is_bayesian_model}
\alias{is_bayesian_model}
\title{Checks if a model is a Bayesian model}
\usage{
is_bayesian_model(x, exclude = NULL)
}
\arguments{
\item{x}{A model object.}

\item{exclude}{Optional character vector, indicating classes that should not
be included in the check. E.g., \code{exclude = "stanreg"} would return \code{FALSE}
for models from package \strong{rstanarm}.}
}
\value{
A logical, \code{TRUE} if \code{x} is a Bayesian model.
}
\description{
Small helper that checks if a model is a Bayesian model.
}
\examples{
\dontshow{if (require("rstanarm", quietly = TRUE)) withAutoprint(\{ # examplesIf}
\donttest{
library(rstanarm)
model <- stan_glm(Sepal.Width ~ Species * Petal.Length, data = iris)
is_bayesian_model(model)
}
\dontshow{\}) # examplesIf}
}
