% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/kill_pid.R
\name{kill_process}
\alias{kill_process}
\title{kill (i.e.: stop) running processes by there process name}
\usage{
kill_process(process, s = 0, m = 0, h = 0, exact = FALSE, ...)
}
\arguments{
\item{process}{a character vector of process names.}

\item{s}{numeric. number of seconds to wait before killing the processes}

\item{m}{numeric. number of minutes to wait before killing the processes}

\item{h}{numeric. number of hours to wait before killing the processes}

\item{exact}{logical (FALSE). should we get exact match to process name, or
can we use just partial matching.}

\item{...}{not used.}
}
\value{
output from system
}
\description{
kill (i.e.: stop) running processes by there process name
It spawns a new Rscript which runs \link[tools]{pskill} on the pid-s
per process name.
}
\examples{
\dontrun{
# create several running processes of Rscript (to shitdown)
system("Rscript -e repeat{2+2}", wait = FALSE) # this process should be stuck
system("Rscript -e repeat{2+2}", wait = FALSE) # this process should be stuck
# here are there pid numbers:
get_Rscript_PID()
# let's kill them:
kill_process("Rscript")
# they are gone...
get_Rscript_PID() # we no longer have Rscripts running
}
}
\references{
tasklist details from microsoft homepage: \url{http://technet.microsoft.com/en-us/library/bb491010.aspx}
pskill details from microsoft homepage: \url{http://technet.microsoft.com/en-us/sysinternals/bb896683.aspx}
}
\seealso{
\code{\link{get_tasklist}}, \code{\link{get_Rscript_PID}}, \code{\link{get_pid}},
\code{\link{kill_pid}}, \code{\link{kill_all_Rscript_s}}, \link[tools]{pskill}
}

