% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interactionR_boot.R
\name{interactionR_boot}
\alias{interactionR_boot}
\title{Confidence intervals for interaction measures using bootstrapping as described by Assmann et al (1996).}
\usage{
interactionR_boot(
  model,
  ci.level = 0.95,
  em = T,
  recode = F,
  seed = 12345,
  s = 1000
)
}
\arguments{
\item{model}{A fitted model object of class glm. Requires that the two binary exposure variables are listed first in the call formula.}

\item{ci.level}{Magnitude of the returned CI level. Default is 0.95}

\item{em}{TRUE (the default), for effect modification assessment. FALSE, for interaction.}

\item{recode}{If TRUE, recodes the exposures - if at least one of the exposures is protective - such that the stratum with the lowest risk becomes the new reference category when the two exposures are considered jointly.}

\item{seed}{The random seed to use for generating the bootstrap samples for confidence intervals (for reproducibility). Default is 12345, but can be set to any number.}

\item{s}{Number of bootstrap resampling. Default is 1000}
}
\value{
a list object of class 'interactionR' that includes a dataframe containing all effect estimates necessary for full reporting of effect modification or interaction analysis. @seealso \code{\link{interactionR_table}} for how to generate a publication-ready table with this object.
}
\description{
Confidence intervals for interaction measures using bootstrapping as described by Assmann et al (1996).
}
\examples{
## Model fitting using dataset from assmann et al.
## The data is available in the package.
m <- glm(h ~ ns * smk,
  family = binomial(link = "logit"),
  data = HDiscdata
)
\donttest{
interactionR_boot(m,
  ci.level = 0.95, em = FALSE, recode = FALSE,
  seed = 12345, s = 1000
)
}
}
\references{
Assmann SF, Hosmer DW, Lemeshow S, Mundt KA. Confidence intervals for measures of interaction. Epidemiology 1996:286-90.
}
