% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{interep}
\alias{interep}
\title{fit a generalized estimating equation with given lambda}
\usage{
interep(e, z, y0, beta, lam1, lam2, corre, maxits)
}
\arguments{
\item{e}{matrix of environment factors.}

\item{z}{matrix of omics factors. In the case study, the omics measurements are lipidomics data.}

\item{y0}{the longitudinal response.}

\item{beta}{the intial value for the coefficient vector.}

\item{lam1}{the tuning parameter lambda1 for individual predictors.}

\item{lam2}{the tuning parameter lambda2 for interactions.}

\item{corre}{the working correlation structure that is used in estimation algorithm. interep provides three choices
for the working correlation structure: "a" as "AR-1", "i" as "independence" and "e" as "exchangeable".}

\item{maxits}{the maximum number of iterations that is used in the estimation algorithm.}
}
\value{
\item{coef}{the coefficient vector.}
}
\description{
This function makes predictions for generalized estimating equation with a given value of lambda.
Typical usage is to have the cv.interep function compute the optimal lambda, then provide it to
the interep function.
}
\details{
When dealing with predictors with both main effects and interactions, this function requires two optimal tuning parameters,
\eqn{\lambda_{1}} and \eqn{\lambda_{2}}; when there are only main effects in the predictors, this function only requires \eqn{\lambda_{1}},
}
\examples{
data("dat")
e=dat$e
z=dat$z
y=dat$y
beta=dat$beta
lam1=dat$lam1
lam2=dat$lam2
index=dat$index
b = interep(e, z, y, beta, lam1, lam2, corre='e',maxits=30)
b[abs(b)<0.05]=0
pos = which(b != 0)
tp = length(intersect(index, pos))
fp = length(pos) - tp
list(tp=tp, fp=fp)

}
\references{
Zhou, F., Ren, J., Li X., Wang, W., Jiang, Y. and Wu, C. (2018+). Variable selection for interactions in longitudinal lipidomics studies.

Wu, C., Zhong, P. & Cui, Y. (2018). Additive varying-coefficient model for nonlinear gene-environment interactions.
\href{https://doi.org/10.1515/sagmb-2017-0008}{\emph{Statistical Applications in Genetics and Molecular Biology}, 17(2)}

Wu, C., Jiang, Y., Ren, J., Cui, Y. and Ma, S. (2018). Dissecting gene-environment interactions: a penalized robust approach accounting for hierarchical structures.
\href{https://doi.org/10.1002/sim.7518}{\emph{Statistics in Medicine}, 37:437–456}

Wu, C., Shi, X., Cui, Y. and Ma, S. (2015) A penalized robust semiparametric approach for gene-environment interactions.
\href{https://doi.org/10.1002/sim.6609}{\emph{Statistics in Medicine}, 34 (30): 4016–4030}

Wu, C., Cui, Y. and Ma, S. (2014) Integrative analysis of gene-environment interactions under a multi-response partially linear varying coefficient model.
\href{https://doi.org/10.1002/sim.6287}{\emph{Statistics in Medicine}, 33 (28): 4988–4498}

Wu, C. and Cui Y. (2013) A novel method for identifying nonlinear gene-environment interactions in case-control association studies.
\href{https://doi.org/10.1007/s00439-013-1350-z}{\emph{Human Genetics}, 132 (12): 1413–1425}
}
