% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/devtools.R
\name{use_dataframe}
\alias{use_dataframe}
\title{Use a dataframe in a package including structure based documentation}
\usage{
use_dataframe(
  df,
  name = deparse(substitute(df)),
  output = "R/data.R",
  pkg = "."
)
}
\arguments{
\item{df}{the data frame to use}

\item{name}{the name of the variable you wish to use (defaults to whatever the function is called with)}

\item{output}{where to write data documentation code (defaults to \code{R/data.R})}

\item{pkg}{the package (defaults to current)}
}
\value{
nothing, used for side effects.
}
\description{
Using the interfacer framework you can document data during development.
This provides the basic documentation framework for a dataset based on a dataframe
in the correct format into the right place.
}
\details{
If this is your only use case for \code{interfacer} then you will not need
to import \code{interfacer} in your package, as none of the generated code will
depend on it.
}
\examples{
# example code
if (interactive()) {
  # This is not run as it is designed for interactive use only and will
  # write to the userspace after checking that is what the user wants.
  use_dataframe(iris) 
}
}
\concept{document}
