% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as-network.r
\name{as_network}
\alias{as_network}
\alias{as_network.default}
\alias{as_network.Rcpp_SimplexTree}
\alias{as_network.gudhi.simplex_tree.SimplexTree}
\alias{as_network.igraph}
\alias{as_network.network}
\title{Coerce objects to class 'network'}
\usage{
as_network(x, ...)

\method{as_network}{default}(x, index = NULL, ...)

\method{as_network}{Rcpp_SimplexTree}(x, index = NULL, ...)

\method{as_network}{gudhi.simplex_tree.SimplexTree}(x, index = NULL, ...)

\method{as_network}{igraph}(x, ...)

\method{as_network}{network}(x, ...)
}
\arguments{
\item{x}{An R object to be coerced. See Details.}

\item{...}{Additional arguments passed to methods.}

\item{index}{Character string to be added as a vertex attribute containing
0-simplex indices. Ignored if \code{NULL} (the default).}
}
\value{
An object of class 'network'.
}
\description{
Coerce objects to 'network' objects, as implemented in
\link[network:network-package]{the network package}.
}
\details{
\code{as_network()} is a generic function with specific methods for different
simplicial complex S3 classes. It returns a \link[network:network]{network}
object.
}
\examples{
if (requireNamespace("TDA", quietly = TRUE)) {
  # convert a TDA filtration object
  t <- 2 * pi * c(0, 1, 3, 6) / 7
  rf <- TDA::ripsFiltration(
    cbind(x = cos(t), y = sin(t)),
    maxdimension = 2L, maxscale = 1.7
  )
  print(rf$cmplx)
  nw_rf <- as_network(rf)
  print(nw_rf)
  nw_rf2 <- as_network(rf$cmplx)
  print(nw_rf2)
}

if (requireNamespace("simplextree", quietly = TRUE)) {
  # convert a simplextree object
  st <- simplextree::simplex_tree()
  st$insert(list(3:5, 5:6, 8))
  nw_st <- as_network(st)
  print(nw_st)
}

\dontrun{

if (requireNamespace("reticulate", quietly = TRUE)) {
  # convert a Python GUDHI simplex tree
  gd <- reticulate::import("gudhi")
  gd_st <- gd$SimplexTree()
  for (s in list(3:5, 5:6, 8)) gd_st$insert(as.list(s))
  nw_gd <- as_network(gd_st, index = "id")
  print(nw_gd)
}
}

if (requireNamespace("igraph", quietly = TRUE)) {
  # convert an igraph object
  ig <- igraph::graph(c(1,2, 2,3, 1,3, 3,4))
  print(ig)
  nw_ig <- as_network(ig)
  print(nw_ig)
}
}
