% Generated by roxygen2 (4.0.2): do not edit by hand
\name{parDepPlot}
\alias{parDepPlot}
\title{Binary Classifier Interpretation functions: Partial Dependence Plots}
\usage{
parDepPlot(x.name, object, data, xlab = x.name, ylab = if (any(class(object)
  \%in\% c("randomForest", "ada"))) bquote(paste("mean(0.5*logit(P"[1], "))"))
  else bquote(paste("CV mean(0.5*logit(P"[1], "))")), main = if
  (any(class(object) \%in\% c("randomForest", "ada")))
  paste("Partial Dependence on", x.name) else
  paste("Cross-Validated Partial Dependence on", x.name), ...)
}
\arguments{
\item{x.name}{the name of the predictor as a character string for which a partial dependence plot has to be created.}

\item{object}{can be a model or a list of cross- validated models. Currently only binary classification models built using the packages \code{randomForest} and \code{ada} are supported.}

\item{data}{a data frame containing the predictors for the model or a list of data frames for cross-validation with length equal to the number of models.}

\item{xlab}{label for the x-axis.}

\item{ylab}{label for the y-axis.}

\item{main}{main title for the plot.}

\item{...}{other graphical parameters for \code{plot}.}
}
\description{
\code{parDepPlot} creates partial dependence plots for binary (cross-validated) classification models. Currently only binary classification model estimated with the packages \code{randomForest} and \code{ada} are supported.
}
\details{
The response variable in the model is always assumed to take on the values \{0,1\}. Resulting partial dependence plots always refer to class 1.
}
\examples{
library(randomForest)
#Prepare data
data(iris)
iris <- iris[1:100,]
iris$Species <- as.factor(ifelse(factor(iris$Species)=="setosa",0,1))

#Cross-validated models
#Estimate 10 models and create 10 test sets
data <- list()
rf <- list()
for (i in 1:10) {
  ind <- sample(nrow(iris),50)
  rf[[i]] <- randomForest(Species~., iris[ind,])
  data[[i]] <- iris[-ind,]
}


parDepPlot(x.name="Petal.Width", object=rf, data=data)

#Single model
#Estimate a single model
rf <- randomForest(Species~., iris[ind,])
parDepPlot(x.name="Petal.Width", object=rf, data=iris)
}
\author{
Authors: Michel Ballings, and Dirk Van den Poel, Maintainer: \email{Michel.Ballings@GMail.com}
}
\references{
The code in this function uses part of the code from the \code{partialPlot} function in \code{randomForest}. It is expanded and generalized to support cross-validation and other packages.
}

