% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fieldbook_summary.R
\name{fieldbook_summary}
\alias{fieldbook_summary}
\title{Fieldbook summary}
\usage{
fieldbook_summary(
  data,
  last_factor,
  model_facts,
  comp_facts,
  test_comp = "SNK",
  sig_level = 0.05
)
}
\arguments{
\item{data}{Field book data.}

\item{last_factor}{The last factor in your fieldbook.}

\item{model_facts}{Model used for the experimental design.}

\item{comp_facts}{Factors to compare. See details.}

\item{test_comp}{Comparison test (default = "SNK"). Others: "TUKEY",
"DUNCAN".}

\item{sig_level}{Significance level for the analysis (default = 0.05).}
}
\value{
data frame
}
\description{
Function to deploy a summary of the variables
}
\details{
For compare the factors you should use ":". For example, to compare
treatment1 and treatment2: \code{treatment1:treatment2}.
}
\examples{


library(inti)
library(googlesheets4)

if (gs4_has_token()) {

url <- paste0("https://docs.google.com/spreadsheets/d/"
              , "15uwCgQRtR01B3FJaZBE8t_0bOC_8Bbey9ccwVlZH0jg")
# browseURL(url)
gs <- as_sheets_id(url)

(data <- gs \%>\%
    range_read("fb"))

fbsm <- fieldbook_summary(data
                 , last_factor = "dosis"
                 , model_facts = "bloque + cultivar*fuenteN*dosis"
                 , comp_facts = "cultivar:fuenteN:dosis"
                 )
fbsm

# fbsm \%>\% write_sheet(ss = gs, sheet = "fbsm")

}

}
