# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Distance matrix calculation.
#'
#' Calculation of Euclidean or geographic distance. Based on an adaptation of
#'   \code{rdist.earth} in the \code{fields} package.
#'   Uses earth radius = 6378.388 km for great circle distance calculations.
#' @param loc1 A two column matrix representing  the longitude/latitude
#'   (i.e. x/y) coordinates of the first set of distances.
#' @param loc2 A two column matrix representing the longitude/latitude
#'   (i.e. x/y) coordinates of the second set of distances
#'   (for pairwise distance matrix set loc1 = loc2).
#' @param geographic If TRUE, calculate great circle distance.
#'   If FALSE, calculate Euclidean distance.
#' @return A matrix of pairwise distances between each combination
#'   of rows from loc1 and loc2 respectively.
#' @examples
#' data(utsnow)
#' locs1 <- as.matrix(utsnow[, c("LONGITUDE", "LATITUDE")])
#' distMat <- dist_cpp(locs1, locs1, geographic = TRUE)
#' @details
#' Note that while this function is still available to users. It is not
#'   actively used in the \code{intkrige} function. Instead,
#'   for user convenience, distances are calculated using distance
#'   functions in the \code{sp} package.
#' @export
dist_cpp <- function(loc1, loc2, geographic) {
    .Call(`_intkrige_dist_cpp`, loc1, loc2, geographic)
}

nrStep <- function(lam, pCovC, lCovC, pCovR, lCovR, pCovCR, lCovCR, A, pen) {
    .Call(`_intkrige_nrStep`, lam, pCovC, lCovC, pCovR, lCovR, pCovCR, lCovCR, A, pen)
}

nrStep_long <- function(lam, pCovC, lCovC, pCovR, lCovR, pCovCR, lCovCR, A, pen, len) {
    .Call(`_intkrige_nrStep_long`, lam, pCovC, lCovC, pCovR, lCovR, pCovCR, lCovCR, A, pen, len)
}

nrStep_2 <- function(lam, pCovC, lCovC, pCovR, lCovR, pCovCR, lCovCR, A, r, threshold, len) {
    .Call(`_intkrige_nrStep_2`, lam, pCovC, lCovC, pCovR, lCovR, pCovCR, lCovCR, A, r, threshold, len)
}

newRap <- function(lam, pCovC, lCovC, pCovR, lCovR, pCovCR, lCovCR, A, threshold, tolq, maxq, tolp, maxp, eta) {
    .Call(`_intkrige_newRap`, lam, pCovC, lCovC, pCovR, lCovR, pCovCR, lCovCR, A, threshold, tolq, maxq, tolp, maxp, eta)
}

newRap_long <- function(lam, pCovC, lCovC, pCovR, lCovR, pCovCR, lCovCR, A, threshold, tolq, maxq, tolp, maxp, eta, r) {
    .Call(`_intkrige_newRap_long`, lam, pCovC, lCovC, pCovR, lCovR, pCovCR, lCovCR, A, threshold, tolq, maxq, tolp, maxp, eta, r)
}

newRap_2 <- function(lam, pCovC, lCovC, pCovR, lCovR, pCovCR, lCovCR, A, threshold, tolq, maxq, tolp, maxp, eta, r) {
    .Call(`_intkrige_newRap_2`, lam, pCovC, lCovC, pCovR, lCovR, pCovCR, lCovCR, A, threshold, tolq, maxq, tolp, maxp, eta, r)
}

nrShell <- function(pCovC, pCovR, pCovCR, lCovC, lCovR, lCovCR, values, A, thresh, tolq, maxq, tolp, maxp, eta, r, trend, fast) {
    .Call(`_intkrige_nrShell`, pCovC, pCovR, pCovCR, lCovC, lCovR, lCovCR, values, A, thresh, tolq, maxq, tolp, maxp, eta, r, trend, fast)
}

