% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misspecification_test.R
\name{HJMisspecificationTest}
\alias{HJMisspecificationTest}
\title{Compute factor risk premia}
\usage{
HJMisspecificationTest(returns, factors, check_arguments = TRUE)
}
\arguments{
\item{returns}{\verb{n_observations x n_returns}-dimensional matrix of test asset
excess returns.}

\item{factors}{\verb{n_observations x n_factors}-dimensional matrix of risk
factors.}

\item{check_arguments}{boolean \code{TRUE} if you want to check function arguments;
\code{FALSE} otherwise. Default is \code{TRUE}.}
}
\value{
a list containing the HJ test statistic and the corresponding
p-value.
}
\description{
Computes the Hansen-Jagannatan misspecification statistic and
p-value of an asset pricing model from test asset excess returns and
risk factors.
}
\examples{
# import package data on 15 risk factors and 42 test asset excess returns
factors = intrinsicFRP::factors[,-1]
returns = intrinsicFRP::returns[,-1]

# compute the HJ model misspecification test
hj_test = HJMisspecificationTest(returns, factors)

}
