% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optimal_p.R
\encoding{utf-8}
\name{optimal_p}
\alias{optimal_p}
\title{Find an optimal p-value for SONE}
\usage{
optimal_p(sizes, n_sim = 100, plotting = "", n_indicators = 8,
  to_min = (round((n_indicators/2), 0)) - 1, ...)
}
\arguments{
\item{sizes}{An array of sample sizes to be simulated. Can be single value.}

\item{n_sim}{number of simulations. 1000 is a start, 10000 was used in paper, but takes a long time}

\item{plotting}{Plots the result with \code{\link{optimal_p_out}}. Defaults to ''. Possible options: '' - no plot; 'yes' - a regular plot;  'file' -- writes the plot to a tiff file in working directory. If sizes is a single value, plotting is disabled.}

\item{n_indicators}{How many many indicators are there in a scale. The package is tested with 8 indicators (default), but should work with other number.}

\item{to_min}{How many indicators relate to the outcome in the lack of ION condition. In \code{\link{optimal_p}} defaults to (round((n_indicators/2),0)) - 1), i.e close to half the number of indicators.}

\item{...}{further tweaking of the scale simulator, see  \code{\link{scale_sim}} for details.}
}
\value{
Returns the P criterion, as well as the p values for max and min scenario for each sample size. If min pvalue > max pvalue, then p criterion is NA.
}
\description{
a wrapper that runs the maximum and minimum scenarios using \code{\link{scenario_sim}} and provides the optimal p -value
}
\examples{
set.seed(466)
n_sim=100
ptm <- proc.time()
a=optimal_p(sizes=750, n_sim=n_sim, n_indicators=8, cor_to_outcome=0.25)
stp=proc.time() - ptm
print(paste("Currently elapsed:",round(stp[3],1)))
print(paste("Time estimate for n_sim=5000:",round(stp[3]*5000/n_sim,1)))

}

