% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reserved.R
\name{is_reserved}
\alias{is_reserved}
\alias{is_multicast}
\alias{is_unspecified}
\alias{is_loopback}
\alias{is_link_local}
\title{Reserved addresses}
\usage{
is_multicast(x)

is_unspecified(x)

is_loopback(x)

is_link_local(x)
}
\arguments{
\item{x}{An \code{\link{ip_address}} or \code{\link{ip_network}} vector}
}
\value{
A logical vector
}
\description{
Check if an address or network is reserved for special use.
A network is considered reserved if both the \code{network_address()}
and \code{broadcast_address()} are reserved.
}
\details{
These special use addresses are documented in IETF documents
\href{https://tools.ietf.org/html/rfc5735.html}{RFC 5735} (for IPv4) and
\href{https://tools.ietf.org/html/rfc4291}{RFC 4291} (for IPv6).
}
\examples{
# these examples show the reserved networks

is_multicast(ip_network(c("224.0.0.0/4", "ff00::/8")))

is_unspecified(ip_network(c("0.0.0.0/32", "::/128")))

is_loopback(ip_network(c("127.0.0.0/8", "::1/128")))

is_link_local(ip_network(c("169.254.0.0/16", "fe80::/10")))
}
\seealso{
Addresses reserved by IPv6 transition mechanisms can be identified
by functions described in \link{ipv6-transition}.
}
