% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/errorGen.R
\name{errorGen}
\alias{errorGen}
\title{Generate interpolation error stats from validation datasets}
\usage{
errorGen(finalraster, validation.spdf, validation.data, plot = FALSE,
  title = "")
}
\arguments{
\item{finalraster}{RasterLayer object}

\item{validation.spdf}{SpatialPointsDataFrame}

\item{validation.data}{data.frame}

\item{plot}{logical. Plot comparison?}

\item{title}{Plot labels}
}
\value{
List of error statistics
}
\description{
Generate interpolation error stats from validation datasets
}
\examples{
validation.data<-data.frame(rnorm(10,mean=0.2,sd=1))
names(validation.data)<-c("validation")
validation.spdf<-validation.data
validation.data<-as.numeric(unlist(validation.data))
xy<-data.frame(x=c(0:9),y=rep(1,10))
coordinates(validation.spdf)<-xy

m<-matrix(NA,1,10)
out.ras<-raster(m,xmn=0,xmx=ncol(m),ymn=0,ymx=nrow(m))
out.ras[]<-validation.data+rnorm(ncell(out.ras),mean=0.01,sd=0.2)

valid.stats<-errorGen(out.ras,validation.spdf,validation.data,plot=TRUE,title="Validation Plot")
valid.stats
}
\author{
Joseph Stachelek
}

