/*
   NOTE: You need to edit the `libname` command to specify the path to the directory
   where the data file is located. For example: "C:\ipums_directory".
   Edit the `filename` command similarly to include the full path (the directory and the data file name).
*/

libname IPUMS ".";
filename ASCIIDAT "nhgis0730_ds239_20185_nation.dat";

data IPUMS.nhgis0730_ds239_20185_nation;
infile ASCIIDAT pad missover lrecl=3015;

input
  YEAR     $ 1-9
  STUSAB   $ 10-11
  NATION   $ 12-35
  NATIONA  $ 36-36
  AIHHTLI  $ 37-37
  MEMI     $ 38-38
  PCI      $ 39-39
  GEOID    $ 40-79
  NAME_E   $ 80-1079
  AJWBE001   1080-1088
  AJWBE002   1089-1097
  AJWBE003   1098-1106
  AJWBE004   1107-1115
  AJWBE005   1116-1124
  AJWBE006   1125-1133
  AJWBE007   1134-1142
  AJWBE008   1143-1151
  AJWBE009   1152-1160
  AJWBE010   1161-1169
  AJWBE011   1170-1178
  AJWBE012   1179-1187
  AJWBE013   1188-1196
  AJWBE014   1197-1205
  AJWBE015   1206-1214
  AJWBE016   1215-1223
  AJWBE017   1224-1232
  AJWBE018   1233-1241
  AJWBE019   1242-1250
  AJWBE020   1251-1259
  AJWBE021   1260-1268
  AJWBE022   1269-1277
  AJWBE023   1278-1286
  AJWBE024   1287-1295
  AJWBE025   1296-1304
  AJWBE026   1305-1313
  AJWBE027   1314-1322
  AJWBE028   1323-1331
  AJWBE029   1332-1340
  AJWBE030   1341-1349
  AJWBE031   1350-1358
  AJWBE032   1359-1367
  AJWBE033   1368-1376
  AJWBE034   1377-1385
  AJWBE035   1386-1394
  AJWBE036   1395-1403
  AJWBE037   1404-1412
  AJWBE038   1413-1421
  AJWBE039   1422-1430
  AJWBE040   1431-1439
  AJWBE041   1440-1448
  AJWBE042   1449-1457
  AJWBE043   1458-1466
  AJWBE044   1467-1475
  AJWBE045   1476-1484
  AJWBE046   1485-1493
  AJWBE047   1494-1502
  AJWBE048   1503-1511
  AJWBE049   1512-1520
  AJWCE001   1521-1529 .1
  AJWCE002   1530-1538 .1
  AJWCE003   1539-1547 .1
  NAME_M   $ 1548-2547
  AJWBM001   2548-2556
  AJWBM002   2557-2565
  AJWBM003   2566-2574
  AJWBM004   2575-2583
  AJWBM005   2584-2592
  AJWBM006   2593-2601
  AJWBM007   2602-2610
  AJWBM008   2611-2619
  AJWBM009   2620-2628
  AJWBM010   2629-2637
  AJWBM011   2638-2646
  AJWBM012   2647-2655
  AJWBM013   2656-2664
  AJWBM014   2665-2673
  AJWBM015   2674-2682
  AJWBM016   2683-2691
  AJWBM017   2692-2700
  AJWBM018   2701-2709
  AJWBM019   2710-2718
  AJWBM020   2719-2727
  AJWBM021   2728-2736
  AJWBM022   2737-2745
  AJWBM023   2746-2754
  AJWBM024   2755-2763
  AJWBM025   2764-2772
  AJWBM026   2773-2781
  AJWBM027   2782-2790
  AJWBM028   2791-2799
  AJWBM029   2800-2808
  AJWBM030   2809-2817
  AJWBM031   2818-2826
  AJWBM032   2827-2835
  AJWBM033   2836-2844
  AJWBM034   2845-2853
  AJWBM035   2854-2862
  AJWBM036   2863-2871
  AJWBM037   2872-2880
  AJWBM038   2881-2889
  AJWBM039   2890-2898
  AJWBM040   2899-2907
  AJWBM041   2908-2916
  AJWBM042   2917-2925
  AJWBM043   2926-2934
  AJWBM044   2935-2943
  AJWBM045   2944-2952
  AJWBM046   2953-2961
  AJWBM047   2962-2970
  AJWBM048   2971-2979
  AJWBM049   2980-2988
  AJWCM001   2989-2997 .1
  AJWCM002   2998-3006 .1
  AJWCM003   3007-3015 .1
;

label
  YEAR     = "Data File Year"
  STUSAB   = "State Postal Abbreviation"
  NATION   = "Nation Name"
  NATIONA  = "Nation Code"
  AIHHTLI  = "American Indian Trust Land/ Hawaiian Home Land Indicator"
  MEMI     = "Metropolitan/Micropolitan Indicator Flag"
  PCI      = "Principal City Indicator"
  GEOID    = "Census Geographic Identifier"
  NAME_E   = "Estimates: Area Name"
  AJWBE001 = "Estimates: Total"
  AJWBE002 = "Estimates: Male"
  AJWBE003 = "Estimates: Male: Under 5 years"
  AJWBE004 = "Estimates: Male: 5 to 9 years"
  AJWBE005 = "Estimates: Male: 10 to 14 years"
  AJWBE006 = "Estimates: Male: 15 to 17 years"
  AJWBE007 = "Estimates: Male: 18 and 19 years"
  AJWBE008 = "Estimates: Male: 20 years"
  AJWBE009 = "Estimates: Male: 21 years"
  AJWBE010 = "Estimates: Male: 22 to 24 years"
  AJWBE011 = "Estimates: Male: 25 to 29 years"
  AJWBE012 = "Estimates: Male: 30 to 34 years"
  AJWBE013 = "Estimates: Male: 35 to 39 years"
  AJWBE014 = "Estimates: Male: 40 to 44 years"
  AJWBE015 = "Estimates: Male: 45 to 49 years"
  AJWBE016 = "Estimates: Male: 50 to 54 years"
  AJWBE017 = "Estimates: Male: 55 to 59 years"
  AJWBE018 = "Estimates: Male: 60 and 61 years"
  AJWBE019 = "Estimates: Male: 62 to 64 years"
  AJWBE020 = "Estimates: Male: 65 and 66 years"
  AJWBE021 = "Estimates: Male: 67 to 69 years"
  AJWBE022 = "Estimates: Male: 70 to 74 years"
  AJWBE023 = "Estimates: Male: 75 to 79 years"
  AJWBE024 = "Estimates: Male: 80 to 84 years"
  AJWBE025 = "Estimates: Male: 85 years and over"
  AJWBE026 = "Estimates: Female"
  AJWBE027 = "Estimates: Female: Under 5 years"
  AJWBE028 = "Estimates: Female: 5 to 9 years"
  AJWBE029 = "Estimates: Female: 10 to 14 years"
  AJWBE030 = "Estimates: Female: 15 to 17 years"
  AJWBE031 = "Estimates: Female: 18 and 19 years"
  AJWBE032 = "Estimates: Female: 20 years"
  AJWBE033 = "Estimates: Female: 21 years"
  AJWBE034 = "Estimates: Female: 22 to 24 years"
  AJWBE035 = "Estimates: Female: 25 to 29 years"
  AJWBE036 = "Estimates: Female: 30 to 34 years"
  AJWBE037 = "Estimates: Female: 35 to 39 years"
  AJWBE038 = "Estimates: Female: 40 to 44 years"
  AJWBE039 = "Estimates: Female: 45 to 49 years"
  AJWBE040 = "Estimates: Female: 50 to 54 years"
  AJWBE041 = "Estimates: Female: 55 to 59 years"
  AJWBE042 = "Estimates: Female: 60 and 61 years"
  AJWBE043 = "Estimates: Female: 62 to 64 years"
  AJWBE044 = "Estimates: Female: 65 and 66 years"
  AJWBE045 = "Estimates: Female: 67 to 69 years"
  AJWBE046 = "Estimates: Female: 70 to 74 years"
  AJWBE047 = "Estimates: Female: 75 to 79 years"
  AJWBE048 = "Estimates: Female: 80 to 84 years"
  AJWBE049 = "Estimates: Female: 85 years and over"
  AJWCE001 = "Estimates: Median age: Total"
  AJWCE002 = "Estimates: Median age: Male"
  AJWCE003 = "Estimates: Median age: Female"
  NAME_M   = "Margins of error: Area Name"
  AJWBM001 = "Margins of error: Total"
  AJWBM002 = "Margins of error: Male"
  AJWBM003 = "Margins of error: Male: Under 5 years"
  AJWBM004 = "Margins of error: Male: 5 to 9 years"
  AJWBM005 = "Margins of error: Male: 10 to 14 years"
  AJWBM006 = "Margins of error: Male: 15 to 17 years"
  AJWBM007 = "Margins of error: Male: 18 and 19 years"
  AJWBM008 = "Margins of error: Male: 20 years"
  AJWBM009 = "Margins of error: Male: 21 years"
  AJWBM010 = "Margins of error: Male: 22 to 24 years"
  AJWBM011 = "Margins of error: Male: 25 to 29 years"
  AJWBM012 = "Margins of error: Male: 30 to 34 years"
  AJWBM013 = "Margins of error: Male: 35 to 39 years"
  AJWBM014 = "Margins of error: Male: 40 to 44 years"
  AJWBM015 = "Margins of error: Male: 45 to 49 years"
  AJWBM016 = "Margins of error: Male: 50 to 54 years"
  AJWBM017 = "Margins of error: Male: 55 to 59 years"
  AJWBM018 = "Margins of error: Male: 60 and 61 years"
  AJWBM019 = "Margins of error: Male: 62 to 64 years"
  AJWBM020 = "Margins of error: Male: 65 and 66 years"
  AJWBM021 = "Margins of error: Male: 67 to 69 years"
  AJWBM022 = "Margins of error: Male: 70 to 74 years"
  AJWBM023 = "Margins of error: Male: 75 to 79 years"
  AJWBM024 = "Margins of error: Male: 80 to 84 years"
  AJWBM025 = "Margins of error: Male: 85 years and over"
  AJWBM026 = "Margins of error: Female"
  AJWBM027 = "Margins of error: Female: Under 5 years"
  AJWBM028 = "Margins of error: Female: 5 to 9 years"
  AJWBM029 = "Margins of error: Female: 10 to 14 years"
  AJWBM030 = "Margins of error: Female: 15 to 17 years"
  AJWBM031 = "Margins of error: Female: 18 and 19 years"
  AJWBM032 = "Margins of error: Female: 20 years"
  AJWBM033 = "Margins of error: Female: 21 years"
  AJWBM034 = "Margins of error: Female: 22 to 24 years"
  AJWBM035 = "Margins of error: Female: 25 to 29 years"
  AJWBM036 = "Margins of error: Female: 30 to 34 years"
  AJWBM037 = "Margins of error: Female: 35 to 39 years"
  AJWBM038 = "Margins of error: Female: 40 to 44 years"
  AJWBM039 = "Margins of error: Female: 45 to 49 years"
  AJWBM040 = "Margins of error: Female: 50 to 54 years"
  AJWBM041 = "Margins of error: Female: 55 to 59 years"
  AJWBM042 = "Margins of error: Female: 60 and 61 years"
  AJWBM043 = "Margins of error: Female: 62 to 64 years"
  AJWBM044 = "Margins of error: Female: 65 and 66 years"
  AJWBM045 = "Margins of error: Female: 67 to 69 years"
  AJWBM046 = "Margins of error: Female: 70 to 74 years"
  AJWBM047 = "Margins of error: Female: 75 to 79 years"
  AJWBM048 = "Margins of error: Female: 80 to 84 years"
  AJWBM049 = "Margins of error: Female: 85 years and over"
  AJWCM001 = "Margins of error: Median age: Total"
  AJWCM002 = "Margins of error: Median age: Male"
  AJWCM003 = "Margins of error: Median age: Female"
;

format
  AJWBE001  9.
  AJWBE002  9.
  AJWBE003  9.
  AJWBE004  9.
  AJWBE005  9.
  AJWBE006  9.
  AJWBE007  9.
  AJWBE008  9.
  AJWBE009  9.
  AJWBE010  9.
  AJWBE011  9.
  AJWBE012  9.
  AJWBE013  9.
  AJWBE014  9.
  AJWBE015  9.
  AJWBE016  9.
  AJWBE017  9.
  AJWBE018  9.
  AJWBE019  9.
  AJWBE020  9.
  AJWBE021  9.
  AJWBE022  9.
  AJWBE023  9.
  AJWBE024  9.
  AJWBE025  9.
  AJWBE026  9.
  AJWBE027  9.
  AJWBE028  9.
  AJWBE029  9.
  AJWBE030  9.
  AJWBE031  9.
  AJWBE032  9.
  AJWBE033  9.
  AJWBE034  9.
  AJWBE035  9.
  AJWBE036  9.
  AJWBE037  9.
  AJWBE038  9.
  AJWBE039  9.
  AJWBE040  9.
  AJWBE041  9.
  AJWBE042  9.
  AJWBE043  9.
  AJWBE044  9.
  AJWBE045  9.
  AJWBE046  9.
  AJWBE047  9.
  AJWBE048  9.
  AJWBE049  9.
  AJWCE001  10.1
  AJWCE002  10.1
  AJWCE003  10.1
  AJWBM001  9.
  AJWBM002  9.
  AJWBM003  9.
  AJWBM004  9.
  AJWBM005  9.
  AJWBM006  9.
  AJWBM007  9.
  AJWBM008  9.
  AJWBM009  9.
  AJWBM010  9.
  AJWBM011  9.
  AJWBM012  9.
  AJWBM013  9.
  AJWBM014  9.
  AJWBM015  9.
  AJWBM016  9.
  AJWBM017  9.
  AJWBM018  9.
  AJWBM019  9.
  AJWBM020  9.
  AJWBM021  9.
  AJWBM022  9.
  AJWBM023  9.
  AJWBM024  9.
  AJWBM025  9.
  AJWBM026  9.
  AJWBM027  9.
  AJWBM028  9.
  AJWBM029  9.
  AJWBM030  9.
  AJWBM031  9.
  AJWBM032  9.
  AJWBM033  9.
  AJWBM034  9.
  AJWBM035  9.
  AJWBM036  9.
  AJWBM037  9.
  AJWBM038  9.
  AJWBM039  9.
  AJWBM040  9.
  AJWBM041  9.
  AJWBM042  9.
  AJWBM043  9.
  AJWBM044  9.
  AJWBM045  9.
  AJWBM046  9.
  AJWBM047  9.
  AJWBM048  9.
  AJWBM049  9.
  AJWCM001  10.1
  AJWCM002  10.1
  AJWCM003  10.1
;

run;

