% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ir_bc.R
\name{ir_bc_sg}
\alias{ir_bc_sg}
\title{Performs baseline correction on infrared spectra using a Savitzky-Golay baseline}
\usage{
ir_bc_sg(x, ..., return_bl = FALSE)
}
\arguments{
\item{x}{An object of class \code{\link[=ir_new_ir]{ir}}.}

\item{...}{Arguments passed to \code{\link[=ir_smooth]{ir_smooth()}} (except for
\code{method} which is always set to \code{"sg"}).}

\item{return_bl}{A logical value indicating if for each spectrum the baseline
should be returned instead of the corrected intensity values
(\code{return_bl = TRUE}) or not (\code{return_bl = FALSE}).}
}
\value{
An object of class \code{ir} with the baseline corrected spectra and,
if \code{returnbl = TRUE},  the baselines.
}
\description{
\code{ir_bc_sg} computes a smoothed version of spectra using
\code{\link[=ir_smooth]{ir_smooth()}} with \code{method = "sg"} and uses this as baseline
which is subtracted from the spectra to perform a baseline correction
\insertCite{Lasch.2012}{ir}.
}
\examples{
x <-
   ir::ir_sample_data \%>\%
   ir::ir_bc_sg(p = 3, n = 199, ts = 1, m = 0, return_bl = FALSE)

}
\references{
\insertAllCited{}
}
