% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataLS.R
\name{dataLS}
\alias{dataLS}
\title{generate random data for classification as in Long and Servedio (2010)}
\usage{
dataLS(ntr, ntu = ntr, nte, percon)
}
\arguments{
\item{ntr}{number of training data}

\item{ntu}{number of tuning data, default is the same as \code{ntr}}

\item{nte}{number of test data}

\item{percon}{proportion of contamination, must between 0 and 1. If \code{percon > 0}, the labels of the corresponding percenrage of response variable in the training and tuning data are flipped.}
}
\value{
a list with elements xtr, xtu, xte, ytr, ytu, yte for predictors of disjoint training, tuning and test data, and response variable -1/1 of training, tuning and test data.
}
\description{
generate random data for classification as in Long and Servedio (2010)
}
\examples{
dat <- dataLS(ntr=100, nte=100, percon=0)
}
\references{
P. Long and R. Servedio (2010), \emph{Random classification noise defeats all convex potential boosters}, \emph{Machine Learning Journal}, 78(3), 287--304.
}
\author{
Zhu Wang\cr Maintainer: Zhu Wang \email{zhuwang@gmail.com}
}
\keyword{classification}
