% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{ar1_prec_irregular}
\alias{ar1_prec_irregular}
\title{Precision matrix for a stationary Gaussian AR(1) process, observed at
irregularly spaced time points.}
\usage{
ar1_prec_irregular(times, rho, sigma)
}
\arguments{
\item{times}{An vector of positive integers, preferably ordered.}

\item{rho}{A real number strictly less than 1 in absolute value.}

\item{sigma}{A positive real number.}
}
\value{
A square matrix with \code{length(times)} rows.
}
\description{
Creates the precision (inverse covariance) matrix of an AR(1) process with
parameters \code{rho} and \code{sigma}, observed at the time points in the
vector \code{times}. The process is assumed to be in stationarity and to
have Gaussian errors.
}
\examples{
library(Matrix)
times <- c(1, 4:5, 7)
rho <- 0.5
sigma <- 1
ar1_prec_irregular(times, rho, sigma)
}
