% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_IRT.R
\name{plot_distractor_icc}
\alias{plot_distractor_icc}
\title{Plot Empirical Item or Test characteristic curve}
\usage{
plot_distractor_icc(
  raw_resp,
  item,
  key,
  bins = 10,
  ip = NULL,
  theta = NULL,
  x_axis_scale = NULL,
  title = "",
  n_dodge = 1,
  suppress_plot = FALSE,
  ...
)
}
\arguments{
\item{raw_resp}{Raw response matrix.}

\item{item}{The column number, column name or the 'id' of the  the item that
should be plotted.}

\item{key}{A vector of answer key.}

\item{bins}{An integer larger than 2 representing of ability groups examinees
should be grouped into. The default is \code{10}. The maximum value of
\code{bins +  1} is the number of possible total scores.}

\item{ip}{An \code{\link{Itempool-class}} object that is needed for some
plots. If \code{ip} provided and \code{theta} is not provided, then
ability will be estimated using EAP method with prior mean 0 and prior
standard deviation of 1. This is a slower method depending on the size of
the data.}

\item{theta}{A vector of examinee abilities. If \code{theta} values provided
the bins are formed using them instead of sum scores.}

\item{x_axis_scale}{Set the scale of the x-axis. The default value is
\code{NULL}. For if sum score is used scale will be defaulted to
\code{"percent"}, Otherwise if valid \code{theta} or \code{ip} arguments
  provided  the scale defaults to \code{"theta"}.
\describe{
  \item{\strong{\code{"percent"}}}{Percent interval.}
  \item{\strong{\code{"number"}}}{Numbers between 1 and \code{bins}.}
  \item{\strong{\code{"theta"}}}{Theta values equally divided into bins.
  the middle value of the bin is shown in the x-axis. For example, if
  \code{bins = 10}, the first tick of the x-axis will be the mean of
  minimum theta value and tenth percentile theta value.}
  }}

\item{title}{Title of the plot}

\item{n_dodge}{The number of lines the x-axis tick labels should be written
to. This is especially useful if the x-axis tick labels overlap with each
other. The default value is \code{1}, which means all of the labels are
written on the same line.}

\item{suppress_plot}{If \code{FALSE} the function will print the plot. If
\code{TRUE}, function will return the plot object. Default value is
\code{FALSE}.}

\item{...}{Extra parameters that will pass to \code{geom_line}.}
}
\value{
Depending on the value of \code{suppress_plot} function either prints
the proportion of examinees in each bin respond to each distractor  or
returns the plot object.
}
\description{
\code{plot_empirical_icc} plots empirical item or test characteristic curve.
}
\examples{
n_item <- 10 # sample(8:12, 1)
n_theta <- 10000 # sample(100:200, 1)
raw_resp <- matrix(sample(LETTERS[1:4], n_item * n_theta, replace = TRUE),
                   nrow = n_theta, ncol = n_item,
                   dimnames = list(paste0("Examinee-", 1:n_theta),
                                   paste0("Item-", 1:n_item)))
key <- sample(LETTERS[1:4], n_item, replace = TRUE)
plot_distractor_icc(raw_resp, 3, key)
# Change the number of bins
plot_distractor_icc(raw_resp, 3, key, bins = 15)

}
\author{
Emre Gonulates
}
