## ---- include = FALSE---------------------------------------------------------
knitr::opts_chunk$set(
  fig.width = 5,
  collapse = TRUE,
  comment = "#>"
)

## -----------------------------------------------------------------------------
library(irt)

itm_rasch <- item(b = -1.29)
itm_rasch

## -----------------------------------------------------------------------------
prob(ip = itm_rasch, theta = -0.65)

## -----------------------------------------------------------------------------
plot(itm_rasch)

## -----------------------------------------------------------------------------
itm_1pl <- item(b = 0.83, D = 1)
itm_1pl

## -----------------------------------------------------------------------------
prob(ip = itm_1pl, theta = 0.73)

## -----------------------------------------------------------------------------
plot(itm_1pl)

## -----------------------------------------------------------------------------
itm_2pl <- item(a = .94, b = -1.302, D = 1)
itm_2pl

## -----------------------------------------------------------------------------
prob(ip = itm_2pl, theta = -0.53)

## -----------------------------------------------------------------------------
plot(itm_2pl)

## -----------------------------------------------------------------------------
itm_3pl <- item(a = 1.51, b = 2.04, c = .16, D = 1.7)
itm_3pl

## -----------------------------------------------------------------------------
prob(ip = itm_3pl, theta = 1.5)

## -----------------------------------------------------------------------------
plot(itm_3pl)

## -----------------------------------------------------------------------------
itm_4pl <- item(a = 1.2, b = -.74, c = .22, d = .99, D = 1.7)
itm_4pl

## -----------------------------------------------------------------------------
prob(ip = itm_4pl, theta = 1.2)

## -----------------------------------------------------------------------------
plot(itm_4pl)

## -----------------------------------------------------------------------------
itm_grm <- item(a = 0.84, b = c(-1, -.2, .75, 1.78), D = 1.7, model = "GRM")
itm_grm

## -----------------------------------------------------------------------------
prob(ip = itm_grm, theta = 1.13)

## -----------------------------------------------------------------------------
plot(itm_grm)

## -----------------------------------------------------------------------------
itm_gpcm <- item(a = 1.1, b = c(-.74, .3, .91, 2.19), D = 1.7, model = "GPCM")
itm_gpcm

## -----------------------------------------------------------------------------
prob(ip = itm_gpcm, theta = -0.53)

## -----------------------------------------------------------------------------
plot(itm_gpcm)

## -----------------------------------------------------------------------------
itm_pcm <- item(b = c(-1.38, -.18, 1.1), model = "PCM")
itm_pcm

## -----------------------------------------------------------------------------
prob(ip = itm_pcm, theta = -1.09)

## -----------------------------------------------------------------------------
plot(itm_pcm)

## -----------------------------------------------------------------------------
itm_gpcm2 <- item(a = .71, b = .37, d = c(-.18, .11, 1.29), D = 1, 
                  model = "GPCM2")
itm_gpcm2

## -----------------------------------------------------------------------------
prob(ip = itm_gpcm2, theta = 1.3)

## -----------------------------------------------------------------------------
plot(itm_gpcm2)

