% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_ks.R
\name{plot.ks_output}
\alias{plot.ks_output}
\title{Plot Item Fit using Kernel-Smoothing}
\usage{
\method{plot}{ks_output}(
  x,
  item_no,
  ip = NULL,
  title = "",
  ci = 0.95,
  base_r_graph = FALSE,
  suppress_plot = FALSE,
  ...
)
}
\arguments{
\item{x}{The output of \code{ks()} function. If this will be provided
the function will run much faster.}

\item{item_no}{The order (i.e. column number) of the item to be plotted.}

\item{ip}{An \code{\link{Itempool-class}} or \code{\link{Item-class}}
object if expected probabilities are plotted.}

\item{title}{Title of the plot. If the value is \code{NULL},
the plot title will be suppressed.}

\item{ci}{It is either a number indicating the confidence interval that will
be plotted around the item fit line or \code{NULL} if no confidence
interval should be plotted. The default value is 0.95, i.e. 95% confidence
interval will be plotted.}

\item{base_r_graph}{If \code{TRUE} function will plot graphs using base R
graphics. If \code{FALSE} the function will check whether 'ggplot2' package
is installed. If it is installed, it will use 'ggplot2' package for the
plot. The default value is \code{FALSE}.}

\item{suppress_plot}{If \code{FALSE} the function will print the plot. If
\code{TRUE}, function will return the plot object. Default value is
\code{FALSE}.}

\item{...}{further arguments.}
}
\description{
Plot Item Fit using Kernel-Smoothing
}
\examples{
# Generate responses
ip <- generate_ip()
resp <- sim_resp(ip = ip, theta = rnorm(500), prop_missing = .2)
# Run kernel smoothing
ks_data <- ks(resp)
# Plot first item
plot(ks_data, item_no = 1)
# Plot second item with expected probability value
plot(ks_data, item_no = 2, ip = ip)

plot(ks_data, item = 2, ip = ip[[2]])
}
\author{
Emre Gonulates
}
