% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/a18.R
\name{a18_H2O_OH}
\alias{a18_H2O_OH}
\title{18O/16O fractionation factor between water and hydroxide ion}
\usage{
a18_H2O_OH(temp, eq)
}
\arguments{
\item{temp}{Temperature (°C).}

\item{eq}{Equation used for the calculations.
\itemize{
\item \code{Z20-X3LYP}: the theoretical X3LYP/6-311+G(d,p) equation of Zeebe (2020).
\item \code{Z20-MP2}: the theoretical MP2/aug-cc-pVDZ equation of Zeebe (2020).
}}
}
\value{
Returns the 18O/16O fractionation factor.
}
\description{
\code{a18_H2O_OH()} calculates the 18O/16O fractionation factor between
water and aqueous hydroxide ion.
}
\examples{
a18_H2O_OH(temp = 90, eq = "Z20-X3LYP")

}
\references{
Zeebe, R. E. (2020).
Oxygen isotope fractionation between water and the aqueous hydroxide ion.
Geochimica et Cosmochimica Acta, 289, 182-195.
\doi{10.1016/j.gca.2020.08.025}
}
\seealso{
Other fractionation_factors: 
\code{\link{a13_CO2g_CO2aq}()},
\code{\link{a18_CO2acid_c}()},
\code{\link{a18_CO2aq_H2O}()},
\code{\link{a18_CO2g_H2O}()},
\code{\link{a18_CO3_H2O}()},
\code{\link{a18_HCO3_H2O}()},
\code{\link{a18_c_H2O}()},
\code{\link{a_A_B}()}
}
\concept{fractionation_factors}
